/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.field.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nucleus8583.core.charset.CharsetDecoder;
import org.nucleus8583.core.charset.CharsetEncoder;
import org.nucleus8583.core.field.type.FieldType;
import org.nucleus8583.core.util.IOUtils;
import org.nucleus8583.core.xml.Iso8583FieldAlignments;
import org.nucleus8583.core.xml.Iso8583FieldDefinition;

public abstract class AbstractHexBinFieldType
extends FieldType {
    private static final long serialVersionUID = 3977789121124596289L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static int hex2int(char ichar) {
        switch (ichar) {
            case '0': {
                break;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        return 0;
    }

    public AbstractHexBinFieldType(Iso8583FieldDefinition def, Iso8583FieldAlignments defaultAlign, String defaultPadWith, String defaultEmptyValue) {
        super(def, defaultAlign, defaultPadWith, defaultEmptyValue);
    }

    public boolean isBinary() {
        return true;
    }

    public String readString(InputStream in, CharsetDecoder dec) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void write(OutputStream out, CharsetEncoder enc, String value) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void read(InputStream in, CharsetDecoder dec, byte[] value, int streamLength) throws IOException {
        char[] cbuf = new char[streamLength];
        IOUtils.readFully(in, dec, cbuf, streamLength);
        int i = 0;
        int j = 0;
        while (i < streamLength) {
            value[j] = (byte)(AbstractHexBinFieldType.hex2int(cbuf[i]) << 4 | AbstractHexBinFieldType.hex2int(cbuf[i + 1]));
            i += 2;
            ++j;
        }
    }

    protected void write(OutputStream out, CharsetEncoder enc, byte[] value, int valueLength) throws IOException {
        for (int i = 0; i < valueLength; ++i) {
            enc.write(out, HEX[(value[i] & 0xF0) >> 4]);
            enc.write(out, HEX[value[i] & 0xF]);
        }
    }
}

