/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.field.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.nucleus8583.core.charset.CharsetDecoder;
import org.nucleus8583.core.charset.CharsetEncoder;
import org.nucleus8583.core.field.type.AbstractHexBinFieldType;
import org.nucleus8583.core.xml.Iso8583FieldAlignments;
import org.nucleus8583.core.xml.Iso8583FieldDefinition;

public final class HexBinFieldType
extends AbstractHexBinFieldType {
    private static final long serialVersionUID = -5615324004502124085L;
    private final int streamLength;
    private final int length;
    private final char[] padder;

    public HexBinFieldType(Iso8583FieldDefinition def, Iso8583FieldAlignments defaultAlign, String defaultPadWith, String defaultEmptyValue) {
        super(def, defaultAlign, defaultPadWith, defaultEmptyValue);
        if (def.getLength() <= 0) {
            throw new IllegalArgumentException("length must be greater than zero");
        }
        this.length = def.getLength() >> 1;
        this.streamLength = this.length << 1;
        this.padder = new char[this.streamLength];
        Arrays.fill(this.padder, '0');
    }

    public void read(InputStream in, CharsetDecoder dec, byte[] value) throws IOException {
        super.read(in, dec, value, this.streamLength);
    }

    public byte[] readBinary(InputStream in, CharsetDecoder dec) throws IOException {
        byte[] value = new byte[this.length];
        super.read(in, dec, value, this.streamLength);
        return value;
    }

    public void write(OutputStream out, CharsetEncoder enc, byte[] value) throws IOException {
        int vlen = value.length;
        if (vlen == 0) {
            enc.write(out, this.padder, 0, this.streamLength);
        } else if (vlen > this.length) {
            super.write(out, enc, value, this.length);
        } else if (vlen == this.streamLength) {
            super.write(out, enc, value, vlen);
        } else {
            super.write(out, enc, value, vlen);
            enc.write(out, this.padder, 0, this.streamLength - (vlen << 1));
        }
    }
}

