/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.util;

import java.util.Arrays;

public abstract class BitmapHelper {
    private static int bytesIndex(int bitIndex) {
        return bitIndex >> 3;
    }

    public static byte[] create(int nbits) {
        return new byte[BitmapHelper.bytesIndex(nbits - 1) + 1];
    }

    public static void set(byte[] bytes, int bitIndex) {
        int n = BitmapHelper.bytesIndex(bitIndex);
        bytes[n] = (byte)(bytes[n] | 128 >> (bitIndex & 7));
    }

    public static boolean get(byte[] bytes, int bitIndex) {
        return (bytes[BitmapHelper.bytesIndex(bitIndex)] & 128 >> (bitIndex & 7)) != 0;
    }

    public static void clear(byte[] bytes, int bitIndex) {
        int n = BitmapHelper.bytesIndex(bitIndex);
        bytes[n] = (byte)(bytes[n] & ~(128 >> (bitIndex & 7)));
    }

    public static void clear(byte[] bytes) {
        Arrays.fill(bytes, (byte)0);
    }

    public static boolean isEmpty(byte[] bytes) {
        for (int i = bytes.length - 1; i >= 0; --i) {
            if (bytes[i] == 0) continue;
            return false;
        }
        return true;
    }
}

