/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.nucleus8583.core.util.BinaryUtils;
import org.nucleus8583.core.util.BitmapHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Message
implements Serializable {
    private static final long serialVersionUID = -1503040549193848604L;
    private final int count;
    private String mti;
    private final String[] stringValues;
    private final byte[][] binaryValues;
    private final byte[] bits1To128;
    private final byte[] bits129To192;

    public Message() {
        this(192);
    }

    public Message(int count) {
        if (count < 64 || count > 192) {
            throw new IllegalArgumentException("number of fields must in range 64-192");
        }
        this.count = count + 1;
        this.mti = "";
        this.stringValues = new String[this.count];
        this.binaryValues = new byte[this.count][];
        this.bits1To128 = BitmapHelper.create(128);
        this.bits129To192 = BitmapHelper.create(64);
    }

    public void setMti(String mti) {
        if (mti == null || mti.length() != 4) {
            throw new IllegalArgumentException("mti is not valid, must be 4 characters length");
        }
        this.mti = mti;
    }

    public String getMti() {
        return this.mti;
    }

    public void set(int no, byte[] value) {
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (value == null) {
            this.unsafeUnset(no);
        } else {
            this.binaryValues[no] = value;
            this.stringValues[no] = null;
            if (no > 128) {
                BitmapHelper.set(this.bits129To192, no - 129);
            } else {
                BitmapHelper.set(this.bits1To128, no - 1);
            }
        }
    }

    public void set(int no, String value) {
        if (no == 0) {
            this.setMti(value);
            return;
        }
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (value == null) {
            this.unsafeUnset(no);
        } else {
            this.binaryValues[no] = null;
            this.stringValues[no] = value;
            if (no > 128) {
                BitmapHelper.set(this.bits129To192, no - 129);
            } else {
                BitmapHelper.set(this.bits1To128, no - 1);
            }
        }
    }

    public void unsafeSet(int no, String value) {
        this.binaryValues[no] = null;
        this.stringValues[no] = value;
        if (no > 128) {
            BitmapHelper.set(this.bits129To192, no - 129);
        } else {
            BitmapHelper.set(this.bits1To128, no - 1);
        }
    }

    public void unsafeSet(int no, byte[] value) {
        this.binaryValues[no] = value;
        this.stringValues[no] = null;
        if (no > 128) {
            BitmapHelper.set(this.bits129To192, no - 129);
        } else {
            BitmapHelper.set(this.bits1To128, no - 1);
        }
    }

    public void unset(int no) {
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        if (no > 128) {
            BitmapHelper.set(this.bits129To192, no - 129);
        } else {
            BitmapHelper.set(this.bits1To128, no - 1);
        }
        this.binaryValues[no] = null;
        this.stringValues[no] = null;
    }

    public void unsafeUnset(int no) {
        if (no > 128) {
            BitmapHelper.set(this.bits129To192, no - 129);
        } else {
            BitmapHelper.set(this.bits1To128, no - 1);
        }
        this.binaryValues[no] = null;
        this.stringValues[no] = null;
    }

    public Object get(int no) {
        if (no == 0) {
            return this.getMti();
        }
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        byte[] value = this.binaryValues[no];
        if (value != null) {
            return value;
        }
        return this.stringValues[no];
    }

    public String getString(int no) {
        if (no == 0) {
            return this.getMti();
        }
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        return this.stringValues[no];
    }

    public byte[] getBinary(int no) {
        if (no <= 1 || no > 192 || no == 65 || no >= this.count) {
            throw new IllegalArgumentException("field no must be in range 2-" + (this.count - 1) + " and not equals to 65");
        }
        return this.binaryValues[no];
    }

    public String unsafeGetString(int no) {
        return this.stringValues[no];
    }

    public byte[] unsafeGetBinary(int no) {
        return this.binaryValues[no];
    }

    public void clear() {
        this.mti = "";
        Arrays.fill((Object[])this.binaryValues, null);
        Arrays.fill(this.stringValues, null);
        BitmapHelper.clear(this.bits1To128);
        BitmapHelper.clear(this.bits129To192);
    }

    public void dump(Map<Integer, Object> map) {
        map.put(0, this.mti);
        int i = 2;
        int iMin1 = 1;
        int iMin129 = -127;
        while (i < this.count) {
            if (i != 65) {
                byte[] value;
                if (i < 129) {
                    if (BitmapHelper.get(this.bits1To128, iMin1)) {
                        value = this.binaryValues[i];
                        if (value == null) {
                            map.put(i, this.stringValues[i]);
                        } else {
                            map.put(i, this.binaryValues[i]);
                        }
                    }
                } else if (BitmapHelper.get(this.bits129To192, iMin129)) {
                    value = this.binaryValues[i];
                    if (value == null) {
                        map.put(i, this.stringValues[i]);
                    } else {
                        map.put(i, this.binaryValues[i]);
                    }
                }
            }
            ++i;
            ++iMin1;
            ++iMin129;
        }
    }

    public void setResponseMti() {
        char[] chars = this.getMti().toCharArray();
        int num = Character.getNumericValue(chars[2]);
        if ((num & 1) == 0) {
            chars[2] = (char)(num + 49);
            this.setMti(new String(chars));
        }
    }

    public boolean isRequest() {
        char[] chars = this.getMti().toCharArray();
        return (Character.getNumericValue(chars[2]) & 1) == 0;
    }

    public boolean isResponse() {
        return !this.isRequest();
    }

    private boolean equals(byte[] a, byte[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a, b);
    }

    private boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message another = (Message)object;
        if (!this.equals(this.mti, another.mti)) {
            return false;
        }
        if (this.count != another.count) {
            return false;
        }
        for (int i = this.count - 1; i >= 2; --i) {
            if (i == 65) continue;
            if (!this.equals(this.binaryValues[i], another.binaryValues[i])) {
                return false;
            }
            if (this.equals(this.stringValues[i], another.stringValues[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<iso-message>\n");
        sbuf.append("    <iso-field id=\"0\" value=\"");
        sbuf.append(this.mti);
        sbuf.append("\" />\n");
        int i = 2;
        int iMin1 = 1;
        int iMin129 = -127;
        while (i < this.count) {
            if (i != 65) {
                byte[] val;
                if (i < 129) {
                    if (BitmapHelper.get(this.bits1To128, iMin1)) {
                        sbuf.append("    <iso-field id=\"");
                        sbuf.append(i);
                        sbuf.append("\" value=\"");
                        val = this.binaryValues[i];
                        if (val == null) {
                            sbuf.append(this.stringValues[i]);
                        } else {
                            sbuf.append(BinaryUtils.toHex(val));
                        }
                        sbuf.append("\" />\n");
                    }
                } else if (BitmapHelper.get(this.bits129To192, iMin129)) {
                    sbuf.append("    <iso-field id=\"");
                    sbuf.append(i);
                    sbuf.append("\" value=\"");
                    val = this.binaryValues[i];
                    if (val == null) {
                        sbuf.append(this.stringValues[i]);
                    } else {
                        sbuf.append(BinaryUtils.toHex(val));
                    }
                    sbuf.append("\" />\n");
                }
            }
            ++i;
            ++iMin1;
            ++iMin129;
        }
        sbuf.append("</iso-message>\n");
        return sbuf.toString();
    }

    int size() {
        return this.count;
    }

    byte[] directBits1To128() {
        return this.bits1To128;
    }

    byte[] directBits129To192() {
        return this.bits129To192;
    }

    byte[][] directBinaryValues() {
        return this.binaryValues;
    }

    String[] directStringValues() {
        return this.stringValues;
    }
}

