/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.nucleus8583.core.Message;
import org.nucleus8583.core.charset.CharsetDecoder;
import org.nucleus8583.core.charset.CharsetEncoder;
import org.nucleus8583.core.charset.CharsetProvider;
import org.nucleus8583.core.charset.Charsets;
import org.nucleus8583.core.field.type.FieldType;
import org.nucleus8583.core.field.type.FieldTypes;
import org.nucleus8583.core.util.BitmapHelper;
import org.nucleus8583.core.util.ResourceUtils;
import org.nucleus8583.core.xml.FieldDefinition;
import org.nucleus8583.core.xml.MessageDefinition;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageSerializer {
    private static final JAXBContext ctx;
    private static final Schema xsd;
    private static final Comparator<FieldType> sortByFieldId;
    private boolean hasMti;
    private FieldType[] fields;
    private boolean[] binaries;
    private int fieldsCount;
    private String encoding;
    private CharsetEncoder charsetEncoder;
    private CharsetDecoder charsetDecoder;

    public static MessageSerializer create(String location) {
        return new MessageSerializer(location);
    }

    public static MessageSerializer create(InputStream in) {
        return new MessageSerializer(in);
    }

    public static MessageSerializer create(Node node) {
        return new MessageSerializer(node);
    }

    public MessageSerializer(String location) {
        MessageDefinition definition;
        URL found = ResourceUtils.getURL(location);
        if (found == null) {
            throw new RuntimeException("unable to find " + location);
        }
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setSchema(xsd);
            definition = (MessageDefinition)unmarshaller.unmarshal(found);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(definition);
    }

    public MessageSerializer(InputStream in) {
        MessageDefinition definition;
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setSchema(xsd);
            definition = (MessageDefinition)unmarshaller.unmarshal(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(definition);
    }

    public MessageSerializer(Node node) {
        MessageDefinition definition;
        try {
            Unmarshaller unmarshaller = ctx.createUnmarshaller();
            unmarshaller.setSchema(xsd);
            definition = (MessageDefinition)unmarshaller.unmarshal(node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.init(definition);
    }

    private boolean replace(int id, FieldDefinition newdef, List<FieldDefinition> fields, int count) {
        for (int i = 0; i < count; ++i) {
            FieldDefinition def = fields.get(i);
            if (def.getId() != id) continue;
            fields.set(i, newdef);
            return true;
        }
        return false;
    }

    private void init(MessageDefinition definition) {
        int i;
        List<FieldDefinition> fields = definition.getFields();
        int count = fields.size();
        this.hasMti = this.replace(0, FieldDefinition.FIELD_0, fields, count);
        if (!this.hasMti) {
            fields.add(FieldDefinition.FIELD_0);
        }
        if (!this.replace(1, FieldDefinition.FIELD_1, fields, count)) {
            fields.add(FieldDefinition.FIELD_1);
        }
        if (!this.replace(65, FieldDefinition.FIELD_65, fields, count)) {
            fields.add(FieldDefinition.FIELD_65);
        }
        this.fieldsCount = fields.size();
        this.fields = new FieldType[this.fieldsCount];
        for (i = 0; i < this.fieldsCount; ++i) {
            this.fields[i] = FieldTypes.getType(fields.get(i));
        }
        Arrays.sort(this.fields, sortByFieldId);
        for (i = 1; i < this.fieldsCount; ++i) {
            if (this.fields[i].getId() == i) continue;
            throw new IllegalArgumentException("field #" + i + " is not defined");
        }
        this.binaries = new boolean[this.fieldsCount];
        for (i = this.fieldsCount - 1; i >= 0; --i) {
            this.binaries[i] = this.fields[i].isBinary();
        }
        this.encoding = definition.getEncoding();
        CharsetProvider charsetProvider = Charsets.getProvider(this.encoding);
        if (charsetProvider == null) {
            throw new RuntimeException(new UnsupportedEncodingException(this.encoding));
        }
        this.charsetEncoder = charsetProvider.getEncoder();
        this.charsetDecoder = charsetProvider.getDecoder();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void read(byte[] buf, Message out) throws IOException {
        this.read(new ByteArrayInputStream(buf), out);
    }

    public void read(InputStream in, Message out) throws IOException {
        byte[] bits1To128 = out.directBits1To128();
        byte[] bits129To192 = out.directBits129To192();
        int count = out.size();
        if (count > this.fieldsCount) {
            count = this.fieldsCount;
        }
        if (this.hasMti) {
            out.setMti(this.fields[0].readString(in, this.charsetDecoder));
        }
        this.fields[1].read(in, this.charsetDecoder, bits1To128, 0, 8);
        if (BitmapHelper.get(bits1To128, 0)) {
            this.fields[1].read(in, this.charsetDecoder, bits1To128, 8, 8);
        }
        int i = 2;
        int iMin1 = 1;
        int iMin129 = -127;
        while (i < count) {
            if (i == 65) {
                if (BitmapHelper.get(bits1To128, 64)) {
                    this.fields[i].read(in, this.charsetDecoder, bits129To192, 0, 8);
                }
            } else if (i < 129) {
                if (BitmapHelper.get(bits1To128, iMin1)) {
                    if (this.binaries[i]) {
                        out.unsafeSet(i, this.fields[i].readBinary(in, this.charsetDecoder));
                    } else {
                        out.unsafeSet(i, this.fields[i].readString(in, this.charsetDecoder));
                    }
                }
            } else if (BitmapHelper.get(bits129To192, iMin129)) {
                if (this.binaries[i]) {
                    out.unsafeSet(i, this.fields[i].readBinary(in, this.charsetDecoder));
                } else {
                    out.unsafeSet(i, this.fields[i].readString(in, this.charsetDecoder));
                }
            }
            ++i;
            ++iMin1;
            ++iMin129;
        }
    }

    public byte[] write(Message msg) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.write(msg, out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public void write(Message msg, OutputStream out) throws IOException {
        byte[] bits1To128 = msg.directBits1To128();
        byte[] bits129To192 = msg.directBits129To192();
        String mti = msg.getMti();
        byte[][] binaryValues = msg.directBinaryValues();
        String[] stringValues = msg.directStringValues();
        boolean bit1IsOn = false;
        if (BitmapHelper.realBytesInUse(bits1To128) > 8) {
            BitmapHelper.set(bits1To128, 0);
            bit1IsOn = true;
        } else {
            BitmapHelper.clear(bits1To128, 0);
        }
        if (BitmapHelper.isEmpty(bits129To192)) {
            BitmapHelper.clear(bits1To128, 64);
            binaryValues[65] = null;
            stringValues[65] = null;
        } else {
            if (!bit1IsOn) {
                BitmapHelper.set(bits1To128, 0);
                bit1IsOn = true;
            }
            BitmapHelper.set(bits1To128, 64);
            binaryValues[65] = bits129To192;
            stringValues[65] = null;
        }
        int count = msg.size();
        if (count > this.fieldsCount) {
            count = this.fieldsCount;
        }
        if (this.hasMti) {
            this.fields[0].write(out, this.charsetEncoder, mti);
        }
        this.fields[1].write(out, this.charsetEncoder, bits1To128, 0, bit1IsOn ? 16 : 8);
        int i = 2;
        int j = 1;
        while (i < count && i < 129) {
            if (BitmapHelper.get(bits1To128, j)) {
                if (i == 65) {
                    this.fields[i].write(out, this.charsetEncoder, binaryValues[i], 0, 8);
                } else if (this.binaries[i]) {
                    this.fields[i].write(out, this.charsetEncoder, binaryValues[i]);
                } else {
                    this.fields[i].write(out, this.charsetEncoder, stringValues[i]);
                }
            }
            ++i;
            ++j;
        }
        i = 129;
        j = 0;
        while (i < count) {
            if (BitmapHelper.get(bits129To192, j)) {
                if (this.binaries[i]) {
                    this.fields[i].write(out, this.charsetEncoder, binaryValues[i]);
                } else {
                    this.fields[i].write(out, this.charsetEncoder, stringValues[i]);
                }
            }
            ++i;
            ++j;
        }
    }

    static {
        sortByFieldId = new Comparator<FieldType>(){

            @Override
            public int compare(FieldType a, FieldType b) {
                return a.getId() - b.getId();
            }
        };
        try {
            ctx = JAXBContext.newInstance((Class[])new Class[]{MessageDefinition.class});
            xsd = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(ResourceUtils.getURL("classpath:META-INF/nucleus8583/schema/iso-message.xsd"));
        }
        catch (Exception e) {
            StringWriter w = new StringWriter();
            PrintWriter pw = new PrintWriter(w);
            e.printStackTrace(pw);
            pw.flush();
            throw new InternalError(w.toString());
        }
    }
}

