/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.charset;

import java.io.IOException;
import java.io.InputStream;
import org.nucleus8583.core.charset.CharsetDecoder;

public class Utf8Decoder
implements CharsetDecoder {
    public int read(InputStream in) throws IOException {
        int ichar;
        boolean missing = false;
        int ubyte = in.read();
        if (ubyte < 0) {
            return -1;
        }
        if ((ubyte & 0x80) == 0) {
            ichar = ubyte;
        } else if ((ubyte & 0xE0) == 192) {
            ichar = ubyte & 0x1F;
            ubyte = in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
            }
        } else if ((ubyte & 0xF0) == 224) {
            ichar = ubyte & 0xF;
            ubyte = in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                }
            }
        } else if ((ubyte & 0xF8) == 240) {
            ichar = ubyte & 7;
            ubyte = in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                    ubyte = in.read();
                    if (ubyte < 0) {
                        missing = true;
                    } else {
                        ichar = ichar << 6 | ubyte & 0x3F;
                    }
                }
            }
        } else if ((ubyte & 0xFC) == 248) {
            ichar = ubyte & 3;
            ubyte = in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                    ubyte = in.read();
                    if (ubyte < 0) {
                        missing = true;
                    } else {
                        ichar = ichar << 6 | ubyte & 0x3F;
                        ubyte = in.read();
                        if (ubyte < 0) {
                            missing = true;
                        } else {
                            ichar = ichar << 6 | ubyte & 0x3F;
                        }
                    }
                }
            }
        } else if ((ubyte & 0xFE) == 252) {
            ichar = ubyte & 1;
            ubyte = in.read();
            if (ubyte < 0) {
                missing = true;
            } else {
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                } else {
                    ichar = ichar << 6 | ubyte & 0x3F;
                    ubyte = in.read();
                    if (ubyte < 0) {
                        missing = true;
                    } else {
                        ichar = ichar << 6 | ubyte & 0x3F;
                        ubyte = in.read();
                        if (ubyte < 0) {
                            missing = true;
                        } else {
                            ichar = ichar << 6 | ubyte & 0x3F;
                        }
                    }
                }
            }
        } else {
            throw new IOException("data stream contains value (code=" + ubyte + ") which is not compatible with UTF-8 encoding");
        }
        if (missing) {
            throw new IOException("missing data while reading in UTF-8 encoding");
        }
        return ichar;
    }

    public int read(InputStream in, char[] cbuf, int off, int len) throws IOException {
        int ubyte;
        int rlen;
        boolean missing = false;
        int j = off;
        for (rlen = 0; rlen < len && (ubyte = in.read()) >= 0; ++rlen) {
            int ichar;
            if ((ubyte & 0x80) == 0) {
                ichar = ubyte;
            } else if ((ubyte & 0xE0) == 192) {
                ichar = ubyte & 0x1F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xF0) == 224) {
                ichar = ubyte & 0xF;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xF8) == 240) {
                ichar = ubyte & 7;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xFC) == 248) {
                ichar = ubyte & 3;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else if ((ubyte & 0xFE) == 252) {
                ichar = ubyte & 1;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
                ubyte = in.read();
                if (ubyte < 0) {
                    missing = true;
                    break;
                }
                ichar = ichar << 6 | ubyte & 0x3F;
            } else {
                throw new IOException("data stream contains value (code=" + ubyte + ") which is not compatible with UTF-8 encoding");
            }
            cbuf[j++] = (char)ichar;
        }
        if (missing) {
            throw new IOException("missing data while reading in UTF-8 encoding");
        }
        return rlen;
    }
}

