/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.charset;

import java.io.IOException;
import java.io.OutputStream;
import org.nucleus8583.core.charset.CharsetEncoder;

public class Utf8Encoder
implements CharsetEncoder {
    public void write(OutputStream out, int ichar) throws IOException {
        if (ichar < 0) {
            throw new IOException("data contains value " + ((long)ichar & 0xFFFFFFFFL) + " which is not compatible with UTF-8 encoding");
        }
        if (ichar <= 127) {
            out.write(ichar);
        } else if (ichar <= 2047) {
            out.write(0xC0 | ichar >> 6);
            out.write(0x80 | ichar & 0x3F);
        } else if (ichar <= 65535) {
            out.write(0xE0 | ichar >> 12);
            out.write(0x80 | ichar >> 6 & 0x3F);
            out.write(0x80 | ichar & 0x3F);
        } else if (ichar <= 0x1FFFFF) {
            out.write(0xF0 | ichar >> 18);
            out.write(0x80 | ichar >> 12 & 0x3F);
            out.write(0x80 | ichar >> 6 & 0x3F);
            out.write(0x80 | ichar & 0x3F);
        } else if (ichar <= 0x3FFFFFF) {
            out.write(0xF8 | ichar >> 24);
            out.write(0x80 | ichar >> 18 & 0x3F);
            out.write(0x80 | ichar >> 12 & 0x3F);
            out.write(0x80 | ichar >> 6 & 0x3F);
            out.write(0x80 | ichar & 0x3F);
        } else {
            out.write(0xFC | ichar >> 30);
            out.write(0x80 | ichar >> 24 & 0x3F);
            out.write(0x80 | ichar >> 18 & 0x3F);
            out.write(0x80 | ichar >> 12 & 0x3F);
            out.write(0x80 | ichar >> 6 & 0x3F);
            out.write(0x80 | ichar & 0x3F);
        }
    }

    public void write(OutputStream out, char[] cbuf) throws IOException {
        int len = cbuf.length;
        int i = 0;
        while (i < len) {
            this.write(out, cbuf[i++]);
        }
    }

    public void write(OutputStream out, char[] cbuf, int off, int len) throws IOException {
        if (off == 0) {
            int i = 0;
            while (i < len) {
                this.write(out, cbuf[i++]);
            }
        } else {
            int j = off;
            for (int i = 0; i < len; ++i) {
                this.write(out, cbuf[j++]);
            }
        }
    }

    public void write(OutputStream out, String str) throws IOException {
        int len = str.length();
        int i = 0;
        while (i < len) {
            this.write(out, str.charAt(i++));
        }
    }

    public void write(OutputStream out, String str, int off, int len) throws IOException {
        if (off == 0) {
            int i = 0;
            while (i < len) {
                this.write(out, str.charAt(i++));
            }
        } else {
            int j = off;
            for (int i = 0; i < len; ++i) {
                this.write(out, str.charAt(j++));
            }
        }
    }
}

