/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.field.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.nucleus8583.core.charset.CharsetDecoder;
import org.nucleus8583.core.charset.CharsetEncoder;
import org.nucleus8583.core.field.type.AbstractHexBinFieldType;
import org.nucleus8583.core.xml.FieldAlignments;
import org.nucleus8583.core.xml.FieldDefinition;

public final class HexBinFieldType
extends AbstractHexBinFieldType {
    private static final long serialVersionUID = -5615324004502124085L;
    private final int streamLength;
    private final int length;
    private final char[] padder;

    public HexBinFieldType(FieldDefinition def, FieldAlignments defaultAlign, String defaultPadWith, String defaultEmptyValue) {
        super(def, defaultAlign, defaultPadWith, defaultEmptyValue);
        if (def.getLength() <= 0) {
            throw new IllegalArgumentException("length must be greater than zero");
        }
        this.length = def.getLength();
        this.streamLength = this.length << 1;
        this.padder = new char[this.streamLength];
        Arrays.fill(this.padder, '0');
    }

    public void read(InputStream in, CharsetDecoder dec, byte[] value) throws IOException {
        super._read(in, dec, value, 0, this.streamLength);
    }

    public void read(InputStream in, CharsetDecoder dec, byte[] value, int off, int len) throws IOException {
        super._read(in, dec, value, off, len << 1);
    }

    public byte[] readBinary(InputStream in, CharsetDecoder dec) throws IOException {
        byte[] value = new byte[this.length];
        super._read(in, dec, value, 0, this.streamLength);
        return value;
    }

    public void write(OutputStream out, CharsetEncoder enc, byte[] value) throws IOException {
        int vlen = value.length;
        if (vlen > this.length) {
            throw new IllegalArgumentException("value of field #" + this.id + " is too long, expected " + this.length + " but actual is " + vlen);
        }
        if (vlen == 0) {
            enc.write(out, this.padder, 0, this.streamLength);
        } else if (vlen == this.length) {
            super._write(out, enc, value, 0, vlen);
        } else {
            super._write(out, enc, value, 0, vlen);
            enc.write(out, this.padder, 0, this.streamLength - (vlen << 1));
        }
    }

    public void write(OutputStream out, CharsetEncoder enc, byte[] value, int off, int vlen) throws IOException {
        super._write(out, enc, value, off, vlen);
    }
}

