/*
 * Decompiled with CFR 0.152.
 */
package org.nucleus8583.core.field.type;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.nucleus8583.core.charset.CharsetDecoder;
import org.nucleus8583.core.charset.CharsetEncoder;
import org.nucleus8583.core.field.type.AbstractStringFieldType;
import org.nucleus8583.core.util.FastInteger;
import org.nucleus8583.core.util.IOUtils;
import org.nucleus8583.core.xml.FieldAlignments;
import org.nucleus8583.core.xml.FieldDefinition;

public abstract class UnicodeVarStringFieldType
extends AbstractStringFieldType {
    private static final long serialVersionUID = -5615324004502124085L;
    private final int lcount;
    private final int length;
    private final String emptyValue;

    public UnicodeVarStringFieldType(FieldDefinition def, FieldAlignments defaultAlign, String defaultPadWith, String defaultEmptyValue, int lcount, int length) {
        super(def, defaultAlign, defaultPadWith, defaultEmptyValue);
        this.lcount = lcount;
        this.length = length;
        this.emptyValue = def.getEmptyValue() == null ? (defaultEmptyValue == null ? "" : defaultEmptyValue) : def.getEmptyValue();
    }

    public String readString(InputStream in, CharsetDecoder dec) throws IOException {
        int vlen = FastInteger.readUint(in, dec, this.lcount);
        if (vlen == 0) {
            return this.emptyValue;
        }
        char[] cbuf = new char[vlen];
        IOUtils.readFully(in, dec, cbuf, vlen);
        return new String(cbuf);
    }

    public void write(OutputStream out, CharsetEncoder enc, String value) throws IOException {
        int vlen = value.length();
        if (vlen > this.length) {
            throw new IllegalArgumentException("value of field #" + this.id + " is too long, expected 0-" + this.length + " but actual is " + vlen);
        }
        FastInteger.writeUint(out, enc, vlen, this.lcount);
        enc.write(out, value, 0, vlen);
    }
}

