/*
 * Decompiled with CFR 0.152.
 */
package org.objectquery.orientdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.objectquery.generic.ConditionElement;
import org.objectquery.generic.ConditionGroup;
import org.objectquery.generic.ConditionItem;
import org.objectquery.generic.ConditionType;
import org.objectquery.generic.GenericInternalQueryBuilder;
import org.objectquery.generic.GenericObjectQuery;
import org.objectquery.generic.Join;
import org.objectquery.generic.ObjectQueryException;
import org.objectquery.generic.Order;
import org.objectquery.generic.PathItem;
import org.objectquery.generic.Projection;
import org.objectquery.generic.ProjectionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrientDBQueryGenerator {
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private String query;

    OrientDBQueryGenerator(GenericObjectQuery<?> objQuery) {
        this.parameters.clear();
        StringBuilder builder = new StringBuilder();
        if (objQuery.getRootPathItem().getName() != null && !objQuery.getRootPathItem().getName().isEmpty()) {
            objQuery.getRootPathItem().setName("");
        }
        Stack<PathItem> items = new Stack<PathItem>();
        items.push(objQuery.getRootPathItem());
        this.buildQuery(objQuery.getTargetClass(), (GenericInternalQueryBuilder)objQuery.getBuilder(), objQuery.getJoins(), builder, items);
        this.query = builder.toString();
    }

    private void stringfyGroup(ConditionGroup group, StringBuilder builder, Stack<PathItem> parent) {
        if (!group.getConditions().isEmpty()) {
            Iterator eli = group.getConditions().iterator();
            while (eli.hasNext()) {
                ConditionElement el = (ConditionElement)eli.next();
                if (el instanceof ConditionItem) {
                    this.stringfyCondition((ConditionItem)el, builder, parent);
                } else if (el instanceof ConditionGroup) {
                    builder.append(" ( ");
                    this.stringfyGroup((ConditionGroup)el, builder, parent);
                    builder.append(" ) ");
                }
                if (!eli.hasNext()) continue;
                builder.append(" ").append(group.getType().toString()).append(" ");
            }
        }
    }

    private String getConditionType(ConditionType type) {
        switch (type) {
            case CONTAINS: {
                return " contains ";
            }
            case EQUALS: {
                return " = ";
            }
            case IN: {
                return " in ";
            }
            case LIKE: {
                return " like ";
            }
            case GREATER: {
                return " > ";
            }
            case LESS: {
                return " < ";
            }
            case GREATER_EQUALS: {
                return " >= ";
            }
            case LESS_EQUALS: {
                return " <= ";
            }
            case NOT_CONTAINS: {
                return " not contains ";
            }
            case NOT_EQUALS: {
                return " <> ";
            }
            case NOT_IN: {
                return " not in ";
            }
            case NOT_LIKE: {
                return "not like";
            }
            case LIKE_NOCASE: {
                return "";
            }
            case NOT_LIKE_NOCASE: {
                return "";
            }
            case BETWEEN: {
                return " BETWEEN ";
            }
        }
        return "";
    }

    private void buildName(PathItem item, StringBuilder sb) {
        if (item.getParent() == null) {
            sb.append("*");
        }
        GenericInternalQueryBuilder.buildPath((PathItem)item, (StringBuilder)sb);
    }

    private String buildParameterName(ConditionItem cond, Object value) {
        StringBuilder name = new StringBuilder();
        this.buildParameterName(cond, name);
        int i = 1;
        String realName = name.toString();
        while (true) {
            if (!this.parameters.containsKey(realName)) {
                this.parameters.put(realName, value);
                return realName;
            }
            realName = name.toString() + i++;
        }
    }

    private void stringfyCondition(ConditionItem cond, StringBuilder sb, Stack<PathItem> parent) {
        this.buildName(cond.getItem(), sb);
        sb.append(" ").append(this.getConditionType(cond.getType())).append(" ");
        if (cond.getValue() instanceof PathItem) {
            this.buildName((PathItem)cond.getValue(), sb);
        } else if (cond.getValue() instanceof GenericObjectQuery) {
            this.generateSubquery(sb, (GenericObjectQuery)cond.getValue(), parent);
        } else {
            sb.append(":");
            sb.append(this.buildParameterName(cond, cond.getValue()));
        }
        if (cond.getType().equals((Object)ConditionType.BETWEEN)) {
            sb.append(" AND ");
            if (cond.getValueTo() instanceof PathItem) {
                this.buildName((PathItem)cond.getValueTo(), sb);
            } else {
                sb.append(":");
                sb.append(this.buildParameterName(cond, cond.getValueTo()));
            }
        }
    }

    private String resolveFunction(ProjectionType projectionType) {
        switch (projectionType) {
            case AVG: {
                return "AVG";
            }
            case MAX: {
                return "MAX";
            }
            case MIN: {
                return "MIN";
            }
            case COUNT: {
                return "COUNT";
            }
            case SUM: {
                return "SUM";
            }
        }
        return "";
    }

    public void buildQuery(Class<?> clazz, GenericInternalQueryBuilder query, List<Join> joins, StringBuilder builder, Stack<PathItem> parentItem) {
        Projection proj;
        Iterator projections;
        builder.append("select ");
        boolean group = false;
        ArrayList<Projection> groupby = new ArrayList<Projection>();
        if (!query.getProjections().isEmpty()) {
            projections = query.getProjections().iterator();
            while (projections.hasNext()) {
                proj = (Projection)projections.next();
                if (proj.getType() != null) {
                    builder.append(" ").append(this.resolveFunction(proj.getType())).append("(");
                    group = true;
                } else {
                    groupby.add(proj);
                }
                if (proj.getItem() instanceof PathItem) {
                    this.buildName((PathItem)proj.getItem(), builder);
                } else {
                    this.generateSubquery(builder, (GenericObjectQuery)proj.getItem(), parentItem);
                }
                if (proj.getType() != null) {
                    builder.append(")");
                }
                if (!projections.hasNext()) continue;
                builder.append(",");
            }
        }
        builder.append(" from ").append(clazz.getSimpleName());
        if (!joins.isEmpty()) {
            throw new ObjectQueryException("join are not supported by orientdb generator", null);
        }
        if (!query.getConditions().isEmpty()) {
            builder.append(" where ");
            this.stringfyGroup((ConditionGroup)query, builder, parentItem);
        }
        if (!query.getHavings().isEmpty()) {
            throw new ObjectQueryException("having clause was not supported by orientdb generator", null);
        }
        if (group && !groupby.isEmpty()) {
            builder.append(" group by ");
            projections = groupby.iterator();
            while (projections.hasNext()) {
                proj = (Projection)projections.next();
                if (proj.getItem() instanceof PathItem) {
                    this.buildName((PathItem)proj.getItem(), builder);
                } else {
                    this.generateSubquery(builder, (GenericObjectQuery)proj.getItem(), parentItem);
                }
                if (!projections.hasNext()) continue;
                builder.append(",");
            }
        }
        if (!query.getOrders().isEmpty()) {
            builder.append(" order by ");
            Iterator orders = query.getOrders().iterator();
            while (orders.hasNext()) {
                Order ord = (Order)orders.next();
                if (ord.getProjectionType() != null) {
                    throw new ObjectQueryException("group operation in order clause is not supported by orientdb query language", null);
                }
                if (ord.getItem() instanceof PathItem) {
                    this.buildName((PathItem)ord.getItem(), builder);
                } else {
                    this.generateSubquery(builder, (GenericObjectQuery)ord.getItem(), parentItem);
                }
                if (ord.getType() != null) {
                    builder.append(" ").append(ord.getType());
                }
                if (!orders.hasNext()) continue;
                builder.append(',');
            }
        }
    }

    private void setPaths(Stack<PathItem> parentItem) {
        StringBuilder pathValue = new StringBuilder();
        ArrayList<PathItem> toIterate = new ArrayList<PathItem>(parentItem);
        Collections.reverse(toIterate);
        for (PathItem pathItem : toIterate) {
            pathItem.setName(pathValue.toString());
            if (pathValue.length() == 0) {
                pathValue.append("$current.parent");
                continue;
            }
            pathValue.append(".parent");
        }
    }

    private void generateSubquery(StringBuilder builder, GenericObjectQuery<?> goq, Stack<PathItem> parentItem) {
        throw new ObjectQueryException("Unsupported subquery on orientdb implementation");
    }

    private void buildParameterName(ConditionItem conditionItem, StringBuilder builder) {
        GenericInternalQueryBuilder.buildPath((PathItem)conditionItem.getItem(), (StringBuilder)builder, (String)"");
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getQuery() {
        return this.query;
    }
}

