/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.cecilia.maven.plugin.car;

import java.io.File;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public abstract class AbstractCarMojo
extends AbstractMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[0];
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    public static final String CAR_TYPE = "car";
    private File outputDirectory;
    private String finalName;
    private JarArchiver carArchiver;
    private MavenProject project;
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    private MavenProjectHelper projectHelper;
    private ArtifactFactory artifactFactory;
    private boolean forceCreation;

    protected abstract File getClassesDirectory();

    protected final MavenProject getProject() {
        return this.project;
    }

    protected abstract String getClassifier();

    protected abstract String getType();

    protected static File getJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + "." + CAR_TYPE);
    }

    public File createArchive() throws MojoExecutionException {
        File jarFile = AbstractCarMojo.getJarFile(this.outputDirectory, this.finalName, this.getClassifier());
        MavenArchiver archiver = new MavenArchiver();
        archiver.setArchiver(this.carArchiver);
        archiver.setOutputFile(jarFile);
        this.archive.setForced(this.forceCreation);
        try {
            File contentDirectory = this.getClassesDirectory();
            if (!contentDirectory.exists()) {
                this.getLog().warn((CharSequence)"CAR will be empty - no content was marked for inclusion!");
            } else {
                archiver.getArchiver().addDirectory(contentDirectory, DEFAULT_INCLUDES, DEFAULT_EXCLUDES);
            }
            archiver.createArchive(this.project, this.archive);
            return jarFile;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error assembling CAR", e);
        }
    }

    public void execute() throws MojoExecutionException {
        File jarFile = this.createArchive();
        String classifier = this.getClassifier();
        if (classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), this.getType(), classifier, jarFile);
        } else {
            Artifact artifact = this.getProject().getArtifact();
            Artifact newArtifact = this.artifactFactory.createArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), this.getType());
            newArtifact.setFile(jarFile);
            this.getProject().setArtifact(newArtifact);
        }
    }
}

