/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.lifecycle;

import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.control.lifecycle.LifeCycleCoordinator;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;

public abstract class BasicLifeCycleControllerMixin
implements Controller,
LifeCycleCoordinator {
    public int fcState;
    public int fcInvocationCounter;
    public LifeCycleCoordinator fcCoordinator;
    public Component _this_weaveableC;

    private BasicLifeCycleControllerMixin() {
    }

    public void initFcController(InitializationContext ic) throws InstantiationException {
        try {
            if (!(ic.getInterface("lifecycle-controller") instanceof LifeCycleCoordinator)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            try {
                ic.getInterface("/lifecycle-coordinator");
            }
            catch (Exception f) {
                throw new ChainedInstantiationException((Throwable)f, null, "The component must provide a LifeCycleCoordinator interface");
            }
        }
        this._super_initFcController(ic);
    }

    public String getFcState() {
        return this.fcState == 0 ? "STOPPED" : "STARTED";
    }

    public void startFc() throws IllegalLifeCycleException {
        if (this.fcState != 2) {
            this._this_setFcState(true);
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        if (this.fcState == 2) {
            this._this_stopFc(new LifeCycleCoordinator[]{this.getFcCoordinator()});
            this._this_setFcState(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFcStarted() throws IllegalLifeCycleException {
        BasicLifeCycleControllerMixin basicLifeCycleControllerMixin = this;
        synchronized (basicLifeCycleControllerMixin) {
            if (this.fcState == 2) {
                return false;
            }
            this.fcState = 2;
            this.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFcStopping(LifeCycleCoordinator coordinator) throws IllegalLifeCycleException {
        BasicLifeCycleControllerMixin basicLifeCycleControllerMixin = this;
        synchronized (basicLifeCycleControllerMixin) {
            this.fcState = 1;
            this.fcCoordinator = coordinator;
            if (this.fcInvocationCounter == 0) {
                this.fcCoordinator.fcInactivated(this.getFcCoordinator());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFcStopped() throws IllegalLifeCycleException {
        BasicLifeCycleControllerMixin basicLifeCycleControllerMixin = this;
        synchronized (basicLifeCycleControllerMixin) {
            if (this.fcState == 0) {
                return false;
            }
            this.fcState = 0;
            this.fcCoordinator = null;
            return true;
        }
    }

    public void incrementFcInvocationCounter() {
        boolean ok;
        do {
            ok = this.fcState == 0 ? false : (this.fcState == 1 ? (this.fcInvocationCounter == 0 ? this.fcCoordinator.fcActivated(this.getFcCoordinator()) : true) : true);
            if (ok) continue;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!ok);
        ++this.fcInvocationCounter;
    }

    public void decrementFcInvocationCounter() {
        --this.fcInvocationCounter;
        if (this.fcInvocationCounter == 0) {
            this.fcCoordinator.fcInactivated(this.getFcCoordinator());
        }
    }

    public LifeCycleCoordinator getFcCoordinator() {
        try {
            return (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("lifecycle-controller");
        }
        catch (Exception e) {
            try {
                return (LifeCycleCoordinator)this._this_weaveableC.getFcInterface("/lifecycle-coordinator");
            }
            catch (NoSuchInterfaceException f) {
                throw new Error("Internal error");
            }
        }
    }

    public abstract void _this_setFcState(boolean var1) throws IllegalLifeCycleException;

    public abstract void _this_stopFc(LifeCycleCoordinator[] var1) throws IllegalLifeCycleException;

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

