/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Fractal;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.Type;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.factory.GenericFactory;
import org.objectweb.fractal.api.factory.InstantiationException;
import org.objectweb.fractal.api.type.ComponentType;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.Controller;
import org.objectweb.fractal.julia.InitializationContext;
import org.objectweb.fractal.julia.control.content.Util;
import org.objectweb.fractal.julia.factory.ChainedInstantiationException;
import org.objectweb.fractal.julia.factory.Template;
import org.objectweb.fractal.julia.type.BasicComponentType;

public abstract class BasicTemplateMixin
implements Controller,
Template {
    public Type fcInstanceType;
    public Object[] fcContent;
    public Component _this_weaveableC;

    private BasicTemplateMixin() {
    }

    public void initFcController(InitializationContext ic) throws InstantiationException {
        this.fcContent = (Object[])ic.content;
        ComponentType tmplType = (ComponentType)ic.type;
        InterfaceType[] itfTypes = tmplType.getFcInterfaceTypes();
        ArrayList<InterfaceType> itfList = new ArrayList<InterfaceType>();
        for (int j = 0; j < itfTypes.length; ++j) {
            String n = itfTypes[j].getFcItfName();
            if (n.equals("factory")) continue;
            if (n.equals("attribute-controller")) {
                itfList.add(itfTypes[j]);
                continue;
            }
            if (n.equals("component") || n.endsWith("-controller")) continue;
            itfList.add(itfTypes[j]);
        }
        itfTypes = new InterfaceType[itfList.size()];
        itfTypes = itfList.toArray(itfTypes);
        this.fcInstanceType = new BasicComponentType(itfTypes);
        this._super_initFcController(ic);
    }

    public Type getFcInstanceType() {
        return this.fcInstanceType;
    }

    public Object getFcControllerDesc() {
        return this.fcContent[0];
    }

    public Object getFcContentDesc() {
        return this.fcContent[1];
    }

    public Component newFcInstance() throws InstantiationException {
        Component instance;
        Component tmpl;
        int i;
        Component thisComponent;
        try {
            thisComponent = (Component)this._this_weaveableC.getFcInterface("component");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedInstantiationException((Throwable)e, this._this_weaveableC, "The template component must provide the Component interface");
        }
        List allSubTemplates = Util.getAllSubComponents((Component)thisComponent);
        HashMap<Component, Component> instances = new HashMap<Component, Component>();
        for (i = 0; i < allSubTemplates.size(); ++i) {
            Template t;
            tmpl = (Component)allSubTemplates.get(i);
            try {
                t = (Template)tmpl.getFcInterface("factory");
            }
            catch (Exception e) {
                try {
                    t = (Template)tmpl.getFcInterface("/template");
                }
                catch (NoSuchInterfaceException f) {
                    throw new ChainedInstantiationException((Throwable)f, this._this_weaveableC, "All the (sub) templates must provide the Template interface");
                }
            }
            Component instance2 = t.newFcControllerInstance();
            instances.put(tmpl, instance2);
        }
        for (i = 0; i < allSubTemplates.size(); ++i) {
            ContentController instanceCC;
            ContentController tmplCC;
            tmpl = (Component)allSubTemplates.get(i);
            instance = (Component)instances.get(tmpl);
            try {
                tmplCC = (ContentController)tmpl.getFcInterface("content-controller");
            }
            catch (NoSuchInterfaceException e) {
                continue;
            }
            try {
                instanceCC = (ContentController)instance.getFcInterface("content-controller");
            }
            catch (NoSuchInterfaceException e) {
                throw new ChainedInstantiationException((Throwable)e, tmpl, "A component instantiated from a template with a ContentController interface must provide the ContentController interface");
            }
            Component[] subTemplates = tmplCC.getFcSubComponents();
            Component[] subInstances = instanceCC.getFcSubComponents();
            for (int j = 0; j < subTemplates.length; ++j) {
                Component subInstance = (Component)instances.get(subTemplates[j]);
                boolean add = true;
                for (int k = 0; k < subInstances.length; ++k) {
                    if (!subInstances[k].equals(subInstance)) continue;
                    add = false;
                }
                if (!add) continue;
                try {
                    instanceCC.addFcSubComponent(subInstance);
                    continue;
                }
                catch (IllegalContentException e) {
                    throw new ChainedInstantiationException((Throwable)e, tmpl, "Cannot set the component hierarchy from the template hierarchy");
                }
                catch (IllegalLifeCycleException e) {
                    throw new ChainedInstantiationException((Throwable)e, tmpl, "Cannot set the component hierarchy from the template hierarchy");
                }
            }
        }
        for (i = 0; i < allSubTemplates.size(); ++i) {
            BindingController instanceBC;
            BindingController tmplBC;
            tmpl = (Component)allSubTemplates.get(i);
            instance = (Component)instances.get(tmpl);
            try {
                tmplBC = (BindingController)tmpl.getFcInterface("binding-controller");
            }
            catch (NoSuchInterfaceException e) {
                continue;
            }
            try {
                instanceBC = (BindingController)instance.getFcInterface("binding-controller");
            }
            catch (NoSuchInterfaceException e) {
                throw new ChainedInstantiationException((Throwable)e, tmpl, "A component instantiated from a template with a BindingController interface must provide the BindingController interface");
            }
            String[] itfNames = tmplBC.listFc();
            for (int j = 0; j < itfNames.length; ++j) {
                Object itfValue;
                Component serverTmpl;
                Component serverInstance;
                Interface serverItf;
                String itfName = itfNames[j];
                try {
                    serverItf = (Interface)tmplBC.lookupFc(itfName);
                }
                catch (ClassCastException e) {
                    throw new ChainedInstantiationException((Throwable)e, tmpl, "The server interface of each binding between templates must implement the Interface interface");
                }
                catch (NoSuchInterfaceException e) {
                    throw new ChainedInstantiationException((Throwable)e, tmpl, "The '" + itfName + "' interface returned by the listFc method does not exist");
                }
                if (serverItf == null || (serverInstance = (Component)instances.get(serverTmpl = serverItf.getFcItfOwner())) == null) continue;
                try {
                    if (serverItf.isFcInternalItf()) {
                        ContentController cc = (ContentController)serverInstance.getFcInterface("content-controller");
                        itfValue = cc.getFcInternalInterface(serverItf.getFcItfName());
                    } else {
                        itfValue = serverInstance.getFcInterface(serverItf.getFcItfName());
                    }
                }
                catch (NoSuchInterfaceException e) {
                    throw new ChainedInstantiationException((Throwable)e, serverTmpl, "The server interface '" + serverItf.getFcItfName() + "'is missing in the component instantiated from the template");
                }
                try {
                    if (instanceBC.lookupFc(itfName).equals(itfValue)) {
                        continue;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    instanceBC.bindFc(itfName, itfValue);
                    continue;
                }
                catch (NoSuchInterfaceException e) {
                    throw new ChainedInstantiationException((Throwable)e, tmpl, "Cannot set the component bindings from the template bindings");
                }
                catch (IllegalBindingException e) {
                    throw new ChainedInstantiationException((Throwable)e, tmpl, "Cannot set the component bindings from the template bindings");
                }
                catch (IllegalLifeCycleException e) {
                    throw new ChainedInstantiationException((Throwable)e, tmpl, "Cannot set the component bindings from the template bindings");
                }
            }
        }
        return (Component)instances.get(allSubTemplates.get(0));
    }

    public Component newFcControllerInstance() throws InstantiationException {
        GenericFactory factory;
        if (this.fcContent[1] instanceof Component) {
            return (Component)this.fcContent[1];
        }
        try {
            factory = (GenericFactory)Fractal.getBootstrapComponent().getFcInterface("generic-factory");
        }
        catch (InstantiationException e) {
            throw new ChainedInstantiationException((Throwable)e, this._this_weaveableC, "Cannot find the GenericFactory interface of the bootstrap component, which is needed to instantiate the template");
        }
        catch (NoSuchInterfaceException e) {
            throw new ChainedInstantiationException((Throwable)e, this._this_weaveableC, "Cannot find the GenericFactory interface of the bootstrap component, which is needed to instantiate the template");
        }
        return factory.newFcInstance(this.fcInstanceType, this.fcContent[0], this.fcContent[1]);
    }

    public abstract void _super_initFcController(InitializationContext var1) throws InstantiationException;
}

