/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.binding;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.ContentController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.type.InterfaceType;
import org.objectweb.fractal.julia.ComponentInterface;
import org.objectweb.fractal.julia.Interceptor;
import org.objectweb.fractal.julia.control.binding.ChainedIllegalBindingException;
import org.objectweb.fractal.julia.control.binding.Util;

public abstract class OptimizedCompositeBindingMixin
implements BindingController {
    public Component _this_weaveableC;
    public ContentController _this_weaveableCC;

    private OptimizedCompositeBindingMixin() {
    }

    public void bindFc(InterfaceType clientItfType, String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        this._super_bindFc(clientItfType, clientItfName, serverItf);
        this.setFcShortcuts(clientItfType, clientItfName, serverItf);
    }

    public void unbindFc(InterfaceType clientItfType, String clientItfName) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        this._super_unbindFc(clientItfType, clientItfName);
        this.setFcShortcuts(clientItfType, clientItfName, null);
    }

    public void setFcShortcuts(InterfaceType clientItfType, String clientItfName, Object serverItf) throws NoSuchInterfaceException, IllegalBindingException {
        ComponentInterface citf;
        Interface clientItf = clientItfType.isFcClientItf() ? (Interface)this._this_weaveableC.getFcInterface(clientItfName) : (Interface)this._this_weaveableCC.getFcInternalInterface(clientItfName);
        HashSet visited = new HashSet();
        ArrayList shortcutItfs = new ArrayList();
        ArrayList shortcutImpls = new ArrayList();
        Object itf = serverItf;
        while (itf instanceof ComponentInterface && !((citf = (ComponentInterface)itf).getFcItfImpl() instanceof Interceptor)) {
            try {
                Component owner = citf.getFcItfOwner();
                owner.getFcInterface("content-controller");
                BindingController bc = (BindingController)owner.getFcInterface("binding-controller");
                itf = bc.lookupFc(citf.getFcItfName());
            }
            catch (NoSuchInterfaceException e) {
                break;
            }
        }
        Object impl = itf == null ? null : (itf instanceof ComponentInterface ? ((ComponentInterface)itf).getFcItfImpl() : itf);
        try {
            this.setFcClientShortcuts(clientItf, impl, visited, shortcutItfs, shortcutImpls);
        }
        catch (Exception e) {
            Interface sItf = serverItf instanceof Interface ? (Interface)serverItf : null;
            throw new ChainedIllegalBindingException((Throwable)e, clientItf.getFcItfOwner(), sItf == null ? null : sItf.getFcItfOwner(), clientItf.getFcItfName(), sItf == null ? null : sItf.getFcItfName(), "Cannot create shortcut links");
        }
        for (int i = 0; i < shortcutItfs.size(); ++i) {
            BindingController bc;
            ContentController cc;
            Interface shortcutItf = (Interface)shortcutItfs.get(i);
            Object shortcutImpl = shortcutImpls.get(i);
            Component c = shortcutItf.getFcItfOwner();
            try {
                cc = (ContentController)c.getFcInterface("content-controller");
            }
            catch (NoSuchInterfaceException e) {
                cc = null;
            }
            if (cc != null) {
                ComponentInterface cShortcutItf = (ComponentInterface)shortcutItf;
                if (cShortcutItf.hasFcInterceptor()) {
                    Object newImpl = cShortcutItf.getFcItfImpl();
                    ((Interceptor)newImpl).setFcItfDelegate(shortcutImpl);
                    continue;
                }
                cShortcutItf.setFcItfImpl(shortcutImpl);
                continue;
            }
            try {
                bc = (BindingController)c.getFcInterface("binding-controller");
            }
            catch (NoSuchInterfaceException e) {
                continue;
            }
            try {
                String itfName = shortcutItf.getFcItfName();
                Object o = bc.lookupFc(itfName);
                if (o == null) continue;
                bc.unbindFc(itfName);
                bc.bindFc(itfName, o);
                continue;
            }
            catch (Exception e) {
                Interface sItf = serverItf instanceof Interface ? (Interface)serverItf : null;
                throw new ChainedIllegalBindingException((Throwable)e, clientItf.getFcItfOwner(), sItf == null ? null : sItf.getFcItfOwner(), clientItf.getFcItfName(), sItf == null ? null : sItf.getFcItfName(), "Cannot create shortcut links");
            }
        }
    }

    public void setFcClientShortcuts(Interface clientItf, Object impl, Set visited, List shortcutItfs, List shortcutImpls) throws Exception {
        ContentController cc;
        Component clientComp = clientItf.getFcItfOwner();
        try {
            cc = (ContentController)clientComp.getFcInterface("content-controller");
        }
        catch (NoSuchInterfaceException e) {
            cc = null;
        }
        if (cc != null) {
            ComponentInterface itf;
            try {
                String name = clientItf.getFcItfName();
                itf = clientItf.isFcInternalItf() ? (ComponentInterface)clientComp.getFcInterface(name) : (ComponentInterface)cc.getFcInternalInterface(name);
            }
            catch (NoSuchInterfaceException e) {
                throw new Exception("Cannot create shortcut links");
            }
            catch (ClassCastException e) {
                throw new Exception("Cannot create shortcut links");
            }
            if (!visited.contains(itf)) {
                visited.add(itf);
                shortcutItfs.add(itf);
                shortcutImpls.add(impl);
                if (itf.hasFcInterceptor()) {
                    Object newImpl = itf.getFcItfImpl();
                    this.setFcServerShortcuts((Interface)itf, newImpl, visited, shortcutItfs, shortcutImpls);
                } else {
                    this.setFcServerShortcuts((Interface)itf, impl, visited, shortcutItfs, shortcutImpls);
                }
            }
        } else if (!visited.contains(clientItf)) {
            visited.add(clientItf);
            shortcutItfs.add(clientItf);
            shortcutImpls.add(impl);
        }
    }

    public void setFcServerShortcuts(Interface serverItf, Object impl, Set visited, List shortcutItfs, List shortcutImpls) throws Exception {
        Object[] comps = Util.getFcPotentialClientsOf((Interface)serverItf).toArray();
        for (int i = 0; i < comps.length; ++i) {
            Component comp = (Component)comps[i];
            List clientItfs = Util.getFcClientItfsBoundTo((Component)comp, (Interface)serverItf);
            for (int j = 0; j < clientItfs.size(); ++j) {
                this.setFcClientShortcuts((Interface)clientItfs.get(j), impl, visited, shortcutItfs, shortcutImpls);
            }
        }
    }

    public abstract void _super_bindFc(InterfaceType var1, String var2, Object var3) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException;

    public abstract void _super_unbindFc(InterfaceType var1, String var2) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException;
}

