/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.fractal.julia.control.binding;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.julia.Util;

public class ChainedIllegalBindingException
extends IllegalBindingException {
    private final Throwable exception;
    private transient Component clientComp;
    private transient Component serverComp;
    private final String clientItf;
    private final String serverItf;

    public ChainedIllegalBindingException(Throwable exception, Component clientComponent, Component serverComponent, String clientItf, String serverItf, String message) {
        super(message);
        this.exception = exception;
        this.clientComp = clientComponent;
        this.serverComp = serverComponent;
        this.clientItf = clientItf;
        this.serverItf = serverItf;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Component getClientComponent() {
        if (this.clientComp != null && !(this.clientComp instanceof Interface)) {
            try {
                return (Component)this.clientComp.getFcInterface("component");
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
        }
        return this.clientComp;
    }

    public Component getServerComponent() {
        if (this.serverComp != null && !(this.serverComp instanceof Interface)) {
            try {
                return (Component)this.serverComp.getFcInterface("component");
            }
            catch (NoSuchInterfaceException noSuchInterfaceException) {
                // empty catch block
            }
        }
        return this.serverComp;
    }

    public String getClientInterface() {
        return this.clientItf;
    }

    public String getServerInterface() {
        return this.serverItf;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("IllegalBindingException: ");
        buf.append(this.getMessage());
        buf.append(" (client interface = ");
        Util.toString(this.getClientComponent(), buf);
        buf.append('.');
        buf.append(this.getClientInterface());
        if (this.getServerComponent() != null) {
            buf.append(", server interface = ");
            Util.toString(this.getServerComponent(), buf);
            buf.append('.');
            buf.append(this.getServerInterface());
        }
        buf.append(')');
        return buf.toString();
    }

    public void printStackTrace() {
        if (this.exception != null) {
            System.err.println((Object)this);
            this.exception.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream s) {
        if (this.exception != null) {
            s.println((Object)this);
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printStackTrace(PrintWriter s) {
        if (this.exception != null) {
            s.write((Object)((Object)this) + "\n");
            this.exception.printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Component c = this.getClientComponent();
        out.writeObject(c instanceof Interface ? c : null);
        c = this.getServerComponent();
        out.writeObject(c instanceof Interface ? c : null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.clientComp = (Component)in.readObject();
        this.serverComp = (Component)in.readObject();
    }
}

