/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.jndi2.scn;

import fr.dyade.aaa.jndi2.client.NamingContextFactory;
import fr.dyade.aaa.util.Debug;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ResolveResult;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class scnURLContext
implements Context {
    public static final Logger logger = Debug.getLogger((String)"fr.dyade.aaa.jndi2.scn");
    private static final String URL_PREFIX = "scn:comp/";
    private static final String ENV_PREFIX = "env";
    private Hashtable myEnv;
    private InitialContextFactory namingFactory;

    public scnURLContext(Hashtable env) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("scnURLContext.<init>(" + env + ')'));
        }
        if (env != null) {
            this.myEnv = (Hashtable)env.clone();
            String factoryClassName = (String)this.myEnv.get("scn.naming.factory.class");
            if (factoryClassName == null) {
                this.namingFactory = new NamingContextFactory();
            } else {
                try {
                    Class<?> factoryClass = Class.forName(factoryClassName);
                    this.namingFactory = (InitialContextFactory)factoryClass.newInstance();
                }
                catch (Exception exc) {
                    NamingException ne = new NamingException();
                    ne.setRootCause(exc);
                    throw ne;
                }
            }
        }
    }

    private String getRelativeName(String name) throws NamingException {
        if (!name.startsWith(URL_PREFIX)) {
            throw new NameNotFoundException("Invalid name:" + name);
        }
        name = name.substring(URL_PREFIX.length());
        return name;
    }

    private ResolveResult findContextFor(String name) throws NamingException {
        String rname = this.getRelativeName(name);
        Context context = null;
        context = rname.equals("") ? new scnURLContext(this.myEnv) : this.namingFactory.getInitialContext(this.myEnv);
        if (context == null) {
            throw new NameNotFoundException("No context for this component");
        }
        ResolveResult r = new ResolveResult((Object)context, rname);
        return r;
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("scnURLContext.lookup(" + name + ')'));
        }
        if (name.equals("")) {
            return new scnURLContext(this.myEnv);
        }
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        Object o = ctx.lookup(rname);
        return o;
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        ctx.bind(rname, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        ctx.rebind(rname, obj);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        ctx.unbind(rname);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException("Rename not supported in scn:comp in " + this.getClass().getName());
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.list(rname);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.listBindings(rname);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext not supported in scn:comp in " + this.getClass().getName());
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.createSubcontext(rname);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        if (name.equals("")) {
            return new scnURLContext(this.myEnv);
        }
        ResolveResult r = this.findContextFor(name);
        Context ctx = (Context)r.getResolvedObj();
        String rname = r.getRemainingName().toString();
        return ctx.lookupLink(rname);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return null;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return null;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("scnURLContext: composeName not supported");
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("composeName not supported in scn:comp in " + this.getClass().getName());
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace not implemented in scn:comp in " + this.getClass().getName());
    }
}

