/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.QueueMBean;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.admin.AddQueueCluster;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearQueue;
import org.objectweb.joram.shared.admin.DeleteQueueMessage;
import org.objectweb.joram.shared.admin.GetQueueMessage;
import org.objectweb.joram.shared.admin.GetQueueMessageIds;
import org.objectweb.joram.shared.admin.GetQueueMessageIdsRep;
import org.objectweb.joram.shared.admin.GetQueueMessageRep;
import org.objectweb.joram.shared.admin.ListClusterQueue;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettings;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettingsRep;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsg;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsgRep;
import org.objectweb.joram.shared.admin.Monitor_GetNumberRep;
import org.objectweb.joram.shared.admin.Monitor_GetPendingMessages;
import org.objectweb.joram.shared.admin.Monitor_GetPendingRequests;
import org.objectweb.joram.shared.admin.RemoveQueueCluster;
import org.objectweb.joram.shared.admin.SetNbMaxMsg;
import org.objectweb.joram.shared.admin.SetQueueThreshold;
import org.objectweb.joram.shared.admin.UnsetQueueThreshold;
import org.objectweb.util.monolog.api.BasicLevel;

public class Queue
extends Destination
implements javax.jms.Queue,
QueueMBean {
    private static final long serialVersionUID = 1L;
    private static final String QUEUE_TYPE = "queue";

    public static boolean isQueue(String type) {
        return Destination.isAssignableTo(type, QUEUE_TYPE);
    }

    public Queue() {
        super(QUEUE_TYPE);
    }

    public Queue(String name) {
        super(name, QUEUE_TYPE);
    }

    protected Queue(String name, String type) {
        super(name, type);
    }

    public String getQueueName() throws JMSException {
        return this.getName();
    }

    public static Queue create(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        Queue queue;
        block2: {
            queue = new Queue();
            Queue.doCreate(serverId, name, className, prop, queue, QUEUE_TYPE);
            StringBuffer buff = new StringBuffer();
            buff.append("type=").append(QUEUE_TYPE);
            buff.append(",name=").append(name);
            try {
                MXWrapper.registerMBean((Object)queue, (String)"joramClient", (String)buff.toString());
            }
            catch (Exception e) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block2;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"registerMBean", (Throwable)e);
            }
        }
        return queue;
    }

    public static Queue create(int serverId, String className, Properties prop) throws ConnectException, AdminException {
        return Queue.create(serverId, null, className, prop);
    }

    public static Queue create(int serverId, Properties prop) throws ConnectException, AdminException {
        return Queue.create(serverId, "org.objectweb.joram.mom.dest.Queue", prop);
    }

    public static Queue create(int serverId, String name) throws ConnectException, AdminException {
        return Queue.create(serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public static Queue create(String name) throws ConnectException, AdminException {
        return Queue.create(AdminModule.getLocalServerId(), name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public static Queue create(int serverId) throws ConnectException, AdminException {
        return Queue.create(serverId, null, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public static Queue create() throws ConnectException, AdminException {
        return Queue.create(AdminModule.getLocalServerId());
    }

    public void setThreshold(int threshold) throws ConnectException, AdminException {
        if (threshold == -1) {
            AdminModule.doRequest((AdminRequest)new UnsetQueueThreshold(this.agentId));
        } else {
            AdminModule.doRequest((AdminRequest)new SetQueueThreshold(this.agentId, threshold));
        }
    }

    public int getThreshold() throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(this.agentId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)AdminModule.doRequest((AdminRequest)request);
        if (reply.getThreshold() == null) {
            return -1;
        }
        return reply.getThreshold();
    }

    public void setNbMaxMsg(int nbMaxMsg) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new SetNbMaxMsg(this.agentId, nbMaxMsg));
    }

    public int getNbMaxMsg() throws ConnectException, AdminException {
        Monitor_GetNbMaxMsg request = new Monitor_GetNbMaxMsg(this.agentId);
        Monitor_GetNbMaxMsgRep reply = (Monitor_GetNbMaxMsgRep)AdminModule.doRequest((AdminRequest)request);
        return reply.getNbMaxMsg();
    }

    public int getPendingMessages() throws ConnectException, AdminException {
        Monitor_GetPendingMessages request = new Monitor_GetPendingMessages(this.agentId);
        Monitor_GetNumberRep reply = (Monitor_GetNumberRep)AdminModule.doRequest((AdminRequest)request);
        return reply.getNumber();
    }

    public int getPendingRequests() throws ConnectException, AdminException {
        Monitor_GetPendingRequests request = new Monitor_GetPendingRequests(this.agentId);
        Monitor_GetNumberRep reply = (Monitor_GetNumberRep)AdminModule.doRequest((AdminRequest)request);
        return reply.getNumber();
    }

    public String[] getMessageIds() throws AdminException, ConnectException {
        GetQueueMessageIdsRep reply = (GetQueueMessageIdsRep)AdminModule.doRequest((AdminRequest)new GetQueueMessageIds(this.agentId));
        return reply.getMessageIds();
    }

    public javax.jms.Message readMessage(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)AdminModule.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId));
        return Message.wrapMomMessage(null, reply.getMessage());
    }

    public String getMessageDigest(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)AdminModule.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Message: ").append(msg.getJMSMessageID());
        strbuf.append("\n\tTo: ").append(msg.getJMSDestination());
        strbuf.append("\n\tCorrelationId: ").append(msg.getJMSCorrelationID());
        strbuf.append("\n\tDeliveryMode: ").append(msg.getJMSDeliveryMode());
        strbuf.append("\n\tExpiration: ").append(msg.getJMSExpiration());
        strbuf.append("\n\tPriority: ").append(msg.getJMSPriority());
        strbuf.append("\n\tRedelivered: ").append(msg.getJMSRedelivered());
        strbuf.append("\n\tReplyTo: ").append(msg.getJMSReplyTo());
        strbuf.append("\n\tTimestamp: ").append(msg.getJMSTimestamp());
        strbuf.append("\n\tType: ").append(msg.getJMSType());
        return strbuf.toString();
    }

    public Properties getMessageHeader(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)AdminModule.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        prop.setProperty("JMSMessageID", msg.getJMSMessageID());
        prop.setProperty("JMSDestination", msg.getJMSDestination().toString());
        if (msg.getJMSCorrelationID() != null) {
            prop.setProperty("JMSCorrelationID", msg.getJMSCorrelationID());
        }
        prop.setProperty("JMSDeliveryMode", new Integer(msg.getJMSDeliveryMode()).toString());
        prop.setProperty("JMSExpiration", new Long(msg.getJMSExpiration()).toString());
        prop.setProperty("JMSPriority", new Integer(msg.getJMSPriority()).toString());
        prop.setProperty("JMSRedelivered", new Boolean(msg.getJMSRedelivered()).toString());
        if (msg.getJMSReplyTo() != null) {
            prop.setProperty("JMSReplyTo", msg.getJMSReplyTo().toString());
        }
        prop.setProperty("JMSTimestamp", new Long(msg.getJMSTimestamp()).toString());
        if (msg.getJMSType() != null) {
            prop.setProperty("JMSType", msg.getJMSType());
        }
        msg.getOptionalHeader(prop);
        return prop;
    }

    public Properties getMessageProperties(String msgId) throws AdminException, ConnectException, JMSException {
        GetQueueMessageRep reply = (GetQueueMessageRep)AdminModule.doRequest((AdminRequest)new GetQueueMessage(this.agentId, msgId));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        msg.getProperties(prop);
        return prop;
    }

    public void deleteMessage(String msgId) throws AdminException, ConnectException {
        AdminModule.doRequest((AdminRequest)new DeleteQueueMessage(this.agentId, msgId));
    }

    public void clear() throws AdminException, ConnectException {
        AdminModule.doRequest((AdminRequest)new ClearQueue(this.agentId));
    }

    public void addClusteredQueue(Queue addedQueue) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new AddQueueCluster(this.agentId, addedQueue.getName()));
    }

    public void removeClusteredQueue(Queue removedQueue) throws ConnectException, AdminException {
        AdminModule.doRequest((AdminRequest)new RemoveQueueCluster(this.agentId, removedQueue.getName()));
    }

    public String[] getQueueClusterElements() throws ConnectException, AdminException {
        AdminReply reply = AdminModule.doRequest((AdminRequest)new ListClusterQueue(this.agentId));
        Vector list = (Vector)reply.getReplyObject();
        Object[] res = new String[list.size()];
        list.copyInto(res);
        return res;
    }
}

