/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms;

import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.TempDestDeleteRequest;
import org.objectweb.util.monolog.api.BasicLevel;

public class TemporaryQueue
extends Queue
implements javax.jms.TemporaryQueue {
    private static final long serialVersionUID = 1L;
    private static final String TMP_QUEUE_TYPE = "queue.tmp";
    private Connection cnx;

    public static boolean isTemporaryQueue(String type) {
        return Destination.isAssignableTo(type, TMP_QUEUE_TYPE);
    }

    public TemporaryQueue() {
    }

    public TemporaryQueue(String agentId, Connection cnx) {
        super(agentId, TMP_QUEUE_TYPE);
        this.cnx = cnx;
    }

    public String toString() {
        return "TempQueue:" + this.agentId;
    }

    public void delete() throws JMSException {
        if (this.cnx == null) {
            throw new JMSSecurityException("Forbidden call as this TemporaryQueue does not belong to this connection.");
        }
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("--- " + this + ": deleting..."));
        }
        this.cnx.checkConsumers(this.agentId);
        this.cnx.syncRequest((AbstractJmsRequest)new TempDestDeleteRequest(this.agentId));
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)(this + ": deleted."));
        }
    }

    public Connection getCnx() {
        return this.cnx;
    }
}

