/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.connection;

import java.util.Timer;
import java.util.Vector;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.JmsRequestGroup;

public class MultiThreadSyncChannel
implements RequestChannel {
    private SyncRound currentRound;
    private Vector syncRequests;
    private int multiThreadSyncDelay;
    private int multiThreadSyncThreshold;
    private RequestChannel channel;

    MultiThreadSyncChannel(RequestChannel rc, int delay, int threshold) {
        this.channel = rc;
        this.multiThreadSyncDelay = delay;
        this.multiThreadSyncThreshold = threshold;
        this.currentRound = new SyncRound();
        this.syncRequests = new Vector();
    }

    public synchronized void send(AbstractJmsRequest request) throws Exception {
        SyncRound localRound = this.currentRound;
        this.syncRequests.addElement(request);
        if (this.syncRequests.size() < this.multiThreadSyncThreshold) {
            try {
                this.wait(this.multiThreadSyncDelay);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        if (!localRound.done) {
            Object[] requests = new AbstractJmsRequest[this.syncRequests.size()];
            this.syncRequests.copyInto(requests);
            this.syncRequests.clear();
            localRound.done = true;
            this.currentRound = new SyncRound();
            this.channel.send((AbstractJmsRequest)new JmsRequestGroup((AbstractJmsRequest[])requests));
            this.notifyAll();
        }
    }

    public void setTimer(Timer timer) {
        this.channel.setTimer(timer);
    }

    public void connect() throws Exception {
        this.channel.connect();
    }

    public AbstractJmsReply receive() throws Exception {
        return this.channel.receive();
    }

    public void close() {
        this.channel.close();
    }

    private static class SyncRound {
        private volatile boolean done = false;

        private SyncRound() {
        }
    }
}

