/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.connection;

import fr.dyade.aaa.util.Daemon;
import java.util.Hashtable;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.objectweb.joram.client.jms.Connection;
import org.objectweb.joram.client.jms.connection.AbortedRequestException;
import org.objectweb.joram.client.jms.connection.ErrorListener;
import org.objectweb.joram.client.jms.connection.MultiThreadSyncChannel;
import org.objectweb.joram.client.jms.connection.ReplyListener;
import org.objectweb.joram.client.jms.connection.RequestChannel;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsReply;
import org.objectweb.joram.shared.client.AbstractJmsRequest;
import org.objectweb.joram.shared.client.ConsumerMessages;
import org.objectweb.joram.shared.client.MomExceptionReply;
import org.objectweb.joram.shared.client.PingRequest;
import org.objectweb.joram.shared.client.SessDenyRequest;
import org.objectweb.joram.shared.messages.Message;
import org.objectweb.util.monolog.api.BasicLevel;

public class RequestMultiplexer {
    private Connection cnx;
    private volatile int status;
    private RequestChannel channel;
    public Hashtable requestsTable;
    private int requestCounter;
    private DemultiplexerDaemon demtpx;
    private Timer timer;
    private HeartBeatTask heartBeatTask;
    private ExceptionListener exceptionListener;
    private volatile long lastRequestDate;

    public RequestMultiplexer(Connection cnx, RequestChannel channel, long heartBeat) throws JMSException {
        this.channel = channel;
        this.cnx = cnx;
        this.requestsTable = new Hashtable();
        this.requestCounter = 0;
        this.timer = new Timer();
        channel.setTimer(this.timer);
        try {
            channel.connect();
        }
        catch (Exception exc) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            throw new JMSException(exc.toString());
        }
        this.demtpx = new DemultiplexerDaemon();
        this.demtpx.start();
        this.setStatus(0);
        if (heartBeat > 0L) {
            this.heartBeatTask = new HeartBeatTask(heartBeat);
            this.lastRequestDate = System.currentTimeMillis();
            try {
                this.heartBeatTask.start();
            }
            catch (Exception exc) {
                if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
                throw new JMSException(exc.toString());
            }
        }
    }

    private void setStatus(int status) {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("RequestMultiplexer.setStatus(" + Status.toString(status) + ')'));
        }
        this.status = status;
    }

    public boolean isClosed() {
        return this.status == 1;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener;
    }

    public void sendRequest(AbstractJmsRequest request) throws JMSException {
        this.sendRequest(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(AbstractJmsRequest request, ReplyListener listener) throws JMSException {
        RequestMultiplexer requestMultiplexer = this;
        synchronized (requestMultiplexer) {
            if (this.status == 1) {
                throw new IllegalStateException("Connection closed");
            }
            if (this.requestCounter == Integer.MAX_VALUE) {
                this.requestCounter = 0;
            }
            request.setRequestId(this.requestCounter++);
            if (listener != null) {
                this.requestsTable.put(new Integer(request.getRequestId()), listener);
            }
            if (this.heartBeatTask != null) {
                this.lastRequestDate = System.currentTimeMillis();
            }
        }
        try {
            this.channel.send(request);
        }
        catch (Exception exc) {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
            JMSException jmsExc = new JMSException(exc.toString());
            jmsExc.setLinkedException(exc);
            throw jmsExc;
        }
    }

    public void setMultiThreadSync(int delay, int threshold) {
        this.channel = new MultiThreadSyncChannel(this.channel, delay, threshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"RequestMultiplexer.close()");
        }
        RequestMultiplexer requestMultiplexer = this;
        synchronized (requestMultiplexer) {
            if (this.status == 1) {
                return;
            }
            this.setStatus(1);
        }
        if (this.heartBeatTask != null) {
            this.heartBeatTask.cancel();
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.channel.close();
        this.demtpx.stop();
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)(" -> requestsTable=" + this.requestsTable));
        }
        this.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Integer[] requestIds;
        Hashtable hashtable = this.requestsTable;
        synchronized (hashtable) {
            Set keySet = this.requestsTable.keySet();
            requestIds = new Integer[keySet.size()];
            keySet.toArray(requestIds);
        }
        for (int i = 0; i < requestIds.length; ++i) {
            ReplyListener rl = (ReplyListener)this.requestsTable.get(requestIds[i]);
            if (rl == null) continue;
            rl.replyAborted(requestIds[i]);
        }
        this.requestsTable.clear();
    }

    public void abortRequest(int requestId) {
        ReplyListener rl;
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("RequestMultiplexer.abortRequest(" + requestId + ')'));
        }
        if ((rl = this.doAbortRequest(requestId)) != null) {
            rl.replyAborted(requestId);
        }
    }

    private synchronized ReplyListener doAbortRequest(int requestId) {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("RequestMultiplexer.doAbortRequest(" + requestId + ')'));
        }
        if (this.status == 1) {
            return null;
        }
        return (ReplyListener)this.requestsTable.remove(new Integer(requestId));
    }

    private void route(AbstractJmsReply reply) {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("RequestMultiplexer.route(" + reply + ')'));
        }
        int requestId = reply.getCorrelationId();
        Integer requestKey = new Integer(requestId);
        ReplyListener rl = (ReplyListener)this.requestsTable.get(requestKey);
        if (reply instanceof MomExceptionReply) {
            MomExceptionReply excReply = (MomExceptionReply)reply;
            int excType = excReply.getType();
            Object jmsExc = null;
            jmsExc = excType == 2 ? new JMSSecurityException(excReply.getMessage()) : (excType == 3 ? new InvalidDestinationException(excReply.getMessage()) : new JMSException(excReply.getMessage()));
            if (rl instanceof ErrorListener) {
                ((ErrorListener)((Object)rl)).errorReceived(requestId, (JMSException)((Object)jmsExc));
            } else {
                this.onException((Exception)jmsExc);
            }
        } else {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)(" -> rl = " + rl + ')'));
            }
            if (rl != null) {
                try {
                    if (rl.replyReceived(reply)) {
                        this.requestsTable.remove(requestKey);
                    }
                }
                catch (AbortedRequestException exc) {
                    JoramTracing.dbgClient.log(BasicLevel.WARN, (Object)(" -> Request aborted: " + requestId));
                    this.abortReply(reply);
                }
            } else {
                if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                    JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)(" -> Listener not found for the reply: " + requestId));
                }
                this.abortReply(reply);
            }
        }
    }

    private void abortReply(AbstractJmsReply reply) {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("RequestMultiplexer.abortReply(" + reply + ')'));
        }
        if (reply instanceof ConsumerMessages) {
            this.deny((ConsumerMessages)reply);
        }
    }

    public void deny(ConsumerMessages messages) {
        block4: {
            if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("RequestMultiplexer.deny(" + messages + ')'));
            }
            Vector msgList = messages.getMessages();
            Vector<String> ids = new Vector<String>();
            for (int i = 0; i < msgList.size(); ++i) {
                ids.addElement(((Message)msgList.elementAt((int)i)).id);
            }
            SessDenyRequest deny = new SessDenyRequest(messages.comesFrom(), ids, messages.getQueueMode());
            try {
                this.sendRequest((AbstractJmsRequest)deny);
            }
            catch (JMSException exc) {
                if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block4;
                JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
            }
        }
    }

    private void onException(Exception exc) {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("RequestMultiplexer.onException(" + exc + ')'));
        }
        JMSException jmsExc = exc instanceof JMSException ? (JMSException)((Object)exc) : new IllegalStateException(exc.getMessage());
        if (this.exceptionListener != null) {
            this.exceptionListener.onException(jmsExc);
        }
    }

    public void schedule(TimerTask task, long period) {
        block3: {
            if (this.timer != null) {
                try {
                    this.timer.schedule(task, period);
                }
                catch (Exception exc) {
                    if (!JoramTracing.dbgClient.isLoggable(BasicLevel.ERROR)) break block3;
                    JoramTracing.dbgClient.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                }
            }
        }
    }

    public void setDemultiplexerDaemonName(String name) {
        this.demtpx.setName(name);
    }

    public String getDemultiplexerDaemonName() {
        return this.demtpx.getName();
    }

    private class HeartBeatTask
    extends TimerTask {
        private long heartBeat;

        HeartBeatTask(long heartBeat) {
            this.heartBeat = heartBeat;
        }

        public void run() {
            block3: {
                try {
                    long date = System.currentTimeMillis();
                    if (date - RequestMultiplexer.this.lastRequestDate > this.heartBeat) {
                        RequestMultiplexer.this.sendRequest((AbstractJmsRequest)new PingRequest());
                    }
                }
                catch (Exception exc) {
                    if (!JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) break block3;
                    JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"", (Throwable)exc);
                }
            }
        }

        public void start() throws Exception {
            RequestMultiplexer.this.timer.schedule((TimerTask)this, this.heartBeat, this.heartBeat);
        }
    }

    private class Closer
    implements Runnable {
        private Exception exc;

        Closer(Exception e) {
            this.exc = e;
        }

        public void run() {
            block2: {
                try {
                    RequestMultiplexer.this.cnx.close();
                }
                catch (JMSException exc2) {
                    if (!JoramTracing.dbgClient.isLoggable(BasicLevel.WARN)) break block2;
                    JoramTracing.dbgClient.log(BasicLevel.WARN, (Object)"Error during close", (Throwable)exc2);
                }
            }
            RequestMultiplexer.this.onException(this.exc);
        }
    }

    private class DemultiplexerDaemon
    extends Daemon {
        DemultiplexerDaemon() {
            super("Connection#?");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (this.running) {
                    AbstractJmsReply reply;
                    this.canStop = true;
                    try {
                        reply = RequestMultiplexer.this.channel.receive();
                    }
                    catch (Exception exc) {
                        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
                            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)"Exception during receive", (Throwable)exc);
                        }
                        if (!RequestMultiplexer.this.isClosed()) {
                            RequestMultiplexer.this.close();
                            Closer closer = new Closer(exc);
                            new Thread(closer).start();
                        } else {
                            onExceptionRunner oer = new onExceptionRunner(exc);
                            new Thread(oer).start();
                        }
                        break;
                    }
                    this.canStop = false;
                    RequestMultiplexer.this.route(reply);
                }
            }
            finally {
                this.finish();
            }
        }

        public void stop() {
            if (this.isCurrentThread()) {
                this.finish();
            } else {
                super.stop();
            }
        }

        protected void shutdown() {
        }

        protected void close() {
        }
    }

    class onExceptionRunner
    implements Runnable {
        Exception exc;

        onExceptionRunner(Exception exc) {
            this.exc = exc;
        }

        public void run() {
            RequestMultiplexer.this.onException(this.exc);
        }
    }

    private static class Status {
        public static final int OPEN = 0;
        public static final int CLOSE = 1;
        private static final String[] names = new String[]{"OPEN", "CLOSE"};

        private Status() {
        }

        public static String toString(int status) {
            return names[status];
        }
    }
}

