/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import java.net.ConnectException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.JMSException;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminRequestor;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.Server;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.shared.admin.AddDomainRequest;
import org.objectweb.joram.shared.admin.AddServerRequest;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.CreateDestinationReply;
import org.objectweb.joram.shared.admin.CreateDestinationRequest;
import org.objectweb.joram.shared.admin.CreateUserReply;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.GetConfigRequest;
import org.objectweb.joram.shared.admin.GetDomainNames;
import org.objectweb.joram.shared.admin.GetDomainNamesRep;
import org.objectweb.joram.shared.admin.GetLocalServer;
import org.objectweb.joram.shared.admin.GetLocalServerRep;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettings;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettingsRep;
import org.objectweb.joram.shared.admin.Monitor_GetDestinations;
import org.objectweb.joram.shared.admin.Monitor_GetDestinationsRep;
import org.objectweb.joram.shared.admin.Monitor_GetServersIds;
import org.objectweb.joram.shared.admin.Monitor_GetServersIdsRep;
import org.objectweb.joram.shared.admin.Monitor_GetUsers;
import org.objectweb.joram.shared.admin.Monitor_GetUsersRep;
import org.objectweb.joram.shared.admin.RemoveDomainRequest;
import org.objectweb.joram.shared.admin.RemoveServerRequest;
import org.objectweb.joram.shared.admin.SetDefaultDMQ;
import org.objectweb.joram.shared.admin.SetDefaultThreshold;
import org.objectweb.joram.shared.admin.StopServerRequest;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class AdminWrapper {
    private Server server = null;
    private AdminRequestor requestor;
    public static final String ADM_NAME_PROPERTY = "JoramAdminXML";
    public static final String DEFAULT_ADM_NAME = "default";
    public static Logger logger = Debug.getLogger((String)AdminWrapper.class.getName());

    public final void setTimeOutToAbortRequest(long timeOut) throws ConnectException {
        if (this.requestor == null) {
            throw new ConnectException("Connection not established.");
        }
        this.requestor.setRequestTimeout(timeOut);
    }

    public final long getTimeOutToAbortRequest() throws ConnectException {
        if (this.requestor == null) {
            throw new ConnectException("Connection not established.");
        }
        return this.requestor.getRequestTimeout();
    }

    public AdminWrapper(Connection cnx) throws JMSException, ConnectException, AdminException {
        this.requestor = new AdminRequestor(cnx);
        this.getLocalServer();
    }

    public void close() {
        if (this.requestor != null) {
            this.requestor.close();
        }
        this.requestor = null;
    }

    public boolean isClosed() {
        return this.requestor == null;
    }

    public final void stopServer() throws ConnectException, AdminException {
        this.stopServer(this.getLocalServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopServer(int serverId) throws ConnectException, AdminException {
        try {
            this.doRequest((AdminRequest)new StopServerRequest(serverId));
        }
        catch (ConnectException connectException) {
        }
        finally {
            if (serverId == this.getLocalServerId()) {
                this.close();
            }
        }
    }

    public final void addServer(int sid, String host, String domain, int port, String server) throws ConnectException, AdminException {
        this.addServer(sid, host, domain, port, server, new String[0], new String[0]);
    }

    public final void addServer(int sid, String host, String domain, int port, String server, String[] services, String[] args) throws ConnectException, AdminException {
        if (services == null) {
            throw new AdminException("Expected service names");
        }
        if (args == null) {
            throw new AdminException("Expected service arguments");
        }
        if (services.length != args.length) {
            throw new AdminException("Same number of service names and arguments expected");
        }
        this.doRequest((AdminRequest)new AddServerRequest(sid, host, domain, port, server, services, args));
    }

    public final void removeServer(int sid) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new RemoveServerRequest(sid));
    }

    public final void addDomain(String domain, int sid, int port) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new AddDomainRequest(domain, sid, port));
    }

    public final void addDomain(String domain, String network, int sid, int port) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new AddDomainRequest(domain, network, sid, port));
    }

    public final void removeDomain(String domain) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new RemoveDomainRequest(domain));
    }

    public final String getConfiguration() throws ConnectException, AdminException {
        return this.doRequest((AdminRequest)new GetConfigRequest()).getInfo();
    }

    public final String getDefaultDMQId() throws ConnectException, AdminException {
        return this.getDefaultDMQId(this.getLocalServerId());
    }

    public final String getDefaultDMQId(int serverId) throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(serverId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)this.doRequest((AdminRequest)request);
        if (reply.getDMQName() == null) {
            return null;
        }
        return reply.getDMQName();
    }

    public final void setDefaultDMQId(String dmqId) throws ConnectException, AdminException {
        this.setDefaultDMQId(this.getLocalServerId(), dmqId);
    }

    public final void setDefaultDMQId(int serverId, String dmqId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetDefaultDMQ(serverId, dmqId));
    }

    public final Queue getDefaultDMQ() throws ConnectException, AdminException {
        return this.getDefaultDMQ(this.getLocalServerId());
    }

    public final Queue getDefaultDMQ(int serverId) throws ConnectException, AdminException {
        String reply = this.getDefaultDMQId(serverId);
        if (reply == null) {
            return null;
        }
        return new DeadMQueue(reply);
    }

    public final void setDefaultDMQ(Queue dmq) throws ConnectException, AdminException {
        this.setDefaultDMQ(this.getLocalServerId(), dmq);
    }

    public final void setDefaultDMQ(int serverId, Queue dmq) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetDefaultDMQ(serverId, dmq == null ? null : dmq.getName()));
    }

    public final int getDefaultThreshold() throws ConnectException, AdminException {
        return this.getDefaultThreshold(this.getLocalServerId());
    }

    public final int getDefaultThreshold(int serverId) throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(serverId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)this.doRequest((AdminRequest)request);
        if (reply.getThreshold() == null) {
            return -1;
        }
        return reply.getThreshold();
    }

    public final void setDefaultThreshold(int threshold) throws ConnectException, AdminException {
        this.setDefaultThreshold(this.getLocalServerId(), threshold);
    }

    public final void setDefaultThreshold(int serverId, int threshold) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetDefaultThreshold(serverId, threshold));
    }

    public final int[] getServersIds() throws ConnectException, AdminException {
        return this.getServersIds(null);
    }

    public final int[] getServersIds(String domain) throws ConnectException, AdminException {
        Monitor_GetServersIds request = new Monitor_GetServersIds(this.getLocalServerId(), domain);
        Monitor_GetServersIdsRep reply = (Monitor_GetServersIdsRep)this.doRequest((AdminRequest)request);
        return reply.getIds();
    }

    public final String[] getServersNames() throws ConnectException, AdminException {
        return this.getServersNames(null);
    }

    public final String[] getServersNames(String domain) throws ConnectException, AdminException {
        Monitor_GetServersIds request = new Monitor_GetServersIds(this.getLocalServerId(), domain);
        Monitor_GetServersIdsRep reply = (Monitor_GetServersIdsRep)this.doRequest((AdminRequest)request);
        return reply.getNames();
    }

    public final Server[] getServers() throws ConnectException, AdminException {
        return this.getServers(null);
    }

    public final Server[] getServers(String domain) throws ConnectException, AdminException {
        Monitor_GetServersIds request = new Monitor_GetServersIds(this.getLocalServerId(), domain);
        Monitor_GetServersIdsRep reply = (Monitor_GetServersIdsRep)this.doRequest((AdminRequest)request);
        int[] serverIds = reply.getIds();
        String[] serverNames = reply.getNames();
        String[] serverHostNames = reply.getHostNames();
        Server[] servers = new Server[serverIds.length];
        for (int i = 0; i < serverIds.length; ++i) {
            servers[i] = new Server(serverIds[i], serverNames[i], serverHostNames[i]);
        }
        return servers;
    }

    public final String[] getDomainNames(int serverId) throws ConnectException, AdminException {
        GetDomainNames request = new GetDomainNames(serverId);
        GetDomainNamesRep reply = (GetDomainNamesRep)this.doRequest((AdminRequest)request);
        return reply.getDomainNames();
    }

    public final Destination[] getDestinations() throws ConnectException, AdminException {
        return this.getDestinations(this.getLocalServerId());
    }

    public final Destination[] getDestinations(int serverId) throws ConnectException, AdminException {
        Destination[] dest = null;
        Monitor_GetDestinations request = new Monitor_GetDestinations(serverId);
        Monitor_GetDestinationsRep reply = (Monitor_GetDestinationsRep)this.doRequest((AdminRequest)request);
        String[] ids = reply.getIds();
        if (ids != null && ids.length > 0) {
            String[] names = reply.getNames();
            byte[] types = reply.getTypes();
            dest = new Destination[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                dest[i] = Destination.newInstance(ids[i], names[i], types[i]);
            }
        }
        return dest;
    }

    public Destination createQueue(String name) throws AdminException, ConnectException {
        return this.createQueue(this.getLocalServerId(), name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public Destination createQueue(int serverId, String name) throws AdminException, ConnectException {
        return this.createQueue(serverId, name, "org.objectweb.joram.mom.dest.Queue", null);
    }

    public Destination createQueue(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, className, prop, 2);
        CreateDestinationReply reply = (CreateDestinationReply)this.doRequest((AdminRequest)cdr);
        Queue queue = Queue.createQueue(reply.getId(), name);
        if (AdminModule.wrapper != this) {
            queue.setWrapper(this);
        }
        return queue;
    }

    public Destination createTopic(String name) throws AdminException, ConnectException {
        return this.createTopic(this.getLocalServerId(), name);
    }

    public Destination createTopic(int serverId, String name) throws AdminException, ConnectException {
        return this.createTopic(serverId, name, "org.objectweb.joram.mom.dest.Topic", null);
    }

    public Destination createTopic(int serverId, String name, String className, Properties prop) throws ConnectException, AdminException {
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, className, prop, 1);
        CreateDestinationReply reply = (CreateDestinationReply)this.doRequest((AdminRequest)cdr);
        Topic topic = Topic.createTopic(reply.getId(), name);
        if (AdminModule.wrapper != this) {
            topic.setWrapper(this);
        }
        return topic;
    }

    public Queue createDeadMQueue(int serverId, String name) throws ConnectException, AdminException {
        CreateDestinationRequest cdr = new CreateDestinationRequest(serverId, name, "org.objectweb.joram.mom.dest.DeadMQueue", null, 2);
        CreateDestinationReply reply = (CreateDestinationReply)this.doRequest((AdminRequest)cdr);
        Queue dmq = DeadMQueue.createDeadMQueue(reply.getId(), name);
        if (AdminModule.wrapper != this) {
            dmq.setWrapper(this);
        }
        return dmq;
    }

    public final User[] getUsers() throws ConnectException, AdminException {
        return this.getUsers(this.getLocalServerId());
    }

    public final User[] getUsers(int serverId) throws ConnectException, AdminException {
        User[] list = null;
        Monitor_GetUsers request = new Monitor_GetUsers(serverId);
        Monitor_GetUsersRep reply = (Monitor_GetUsersRep)this.doRequest((AdminRequest)request);
        Hashtable users = reply.getUsers();
        list = new User[users.size()];
        int i = 0;
        Enumeration names = users.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            list[i++] = new User(name, (String)users.get(name));
        }
        return list;
    }

    public User createUser(String name, String password) throws ConnectException, AdminException {
        return this.createUser(name, password, this.getLocalServerId(), SimpleIdentity.class.getName());
    }

    public User createUser(String name, String password, int serverId) throws ConnectException, AdminException {
        return this.createUser(name, password, serverId, SimpleIdentity.class.getName());
    }

    public User createUser(String name, String password, String identityClass) throws AdminException, ConnectException {
        return this.createUser(name, password, this.getLocalServerId(), identityClass);
    }

    public User createUser(String name, String password, int serverId, String identityClassName) throws ConnectException, AdminException {
        Identity identity = this.createIdentity(name, password, identityClassName);
        AdminReply reply = this.doRequest((AdminRequest)new CreateUserRequest(identity, serverId));
        User user = new User(name, ((CreateUserReply)reply).getProxId());
        if (AdminModule.wrapper != this) {
            user.setWrapper(this);
        }
        return user;
    }

    private Identity createIdentity(String user, String passwd, String identityClassName) throws AdminException {
        Identity identity = null;
        try {
            identity = (Identity)Class.forName(identityClassName).newInstance();
            if (passwd != null) {
                identity.setIdentity(user, passwd);
            } else {
                identity.setUserName(user);
            }
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage());
        }
        return identity;
    }

    public final Server getLocalServer() throws ConnectException, AdminException {
        if (this.server == null) {
            GetLocalServerRep reply = (GetLocalServerRep)this.doRequest((AdminRequest)new GetLocalServer());
            this.server = new Server(reply.getId(), reply.getName(), reply.getHostName());
        }
        return this.server;
    }

    public final int getLocalServerId() throws ConnectException, AdminException {
        if (this.requestor == null) {
            throw new ConnectException("Administrator not connected.");
        }
        if (this.server == null) {
            this.getLocalServer();
        }
        return this.server.getId();
    }

    public final String getLocalHost() throws ConnectException, AdminException {
        if (this.requestor == null) {
            throw new ConnectException("Administrator not connected.");
        }
        if (this.server == null) {
            this.getLocalServer();
        }
        return this.server.getHostName();
    }

    public final String getLocalName() throws ConnectException, AdminException {
        if (this.requestor == null) {
            throw new ConnectException("Administrator not connected.");
        }
        if (this.server == null) {
            this.getLocalServer();
        }
        return this.server.getName();
    }

    public AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Admin.doRequest(" + request + ')'));
        }
        if (this.requestor == null) {
            throw new ConnectException("Admin connection not established.");
        }
        return this.requestor.request(request);
    }

    public void abortRequest() throws ConnectException {
        if (this.requestor == null) {
            throw new ConnectException("Admin connection not established.");
        }
        this.requestor.abort();
    }
}

