/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.util.management.MXWrapper;
import java.net.ConnectException;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.objectweb.joram.client.jms.Message;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.admin.AdminException;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.AdminWrapper;
import org.objectweb.joram.client.jms.admin.AdministeredObject;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.Subscription;
import org.objectweb.joram.client.jms.admin.UserMBean;
import org.objectweb.joram.shared.admin.AdminReply;
import org.objectweb.joram.shared.admin.AdminRequest;
import org.objectweb.joram.shared.admin.ClearSubscription;
import org.objectweb.joram.shared.admin.CreateUserReply;
import org.objectweb.joram.shared.admin.CreateUserRequest;
import org.objectweb.joram.shared.admin.DeleteSubscriptionMessage;
import org.objectweb.joram.shared.admin.DeleteUser;
import org.objectweb.joram.shared.admin.GetSubscription;
import org.objectweb.joram.shared.admin.GetSubscriptionMessage;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIds;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageIdsRep;
import org.objectweb.joram.shared.admin.GetSubscriptionMessageRep;
import org.objectweb.joram.shared.admin.GetSubscriptionRep;
import org.objectweb.joram.shared.admin.GetSubscriptions;
import org.objectweb.joram.shared.admin.GetSubscriptionsRep;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettings;
import org.objectweb.joram.shared.admin.Monitor_GetDMQSettingsRep;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsg;
import org.objectweb.joram.shared.admin.Monitor_GetNbMaxMsgRep;
import org.objectweb.joram.shared.admin.SetNbMaxMsg;
import org.objectweb.joram.shared.admin.SetUserDMQ;
import org.objectweb.joram.shared.admin.SetUserThreshold;
import org.objectweb.joram.shared.admin.UpdateUser;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class User
extends AdministeredObject
implements UserMBean {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)User.class.getName());
    String name;
    String proxyId;
    AdminWrapper wrapper = null;
    protected transient String JMXBeanName = null;

    public User() {
    }

    public User(String name, String proxyId) {
        this.name = name;
        this.proxyId = proxyId;
    }

    public String toString() {
        return "User[" + this.name + "]:" + this.proxyId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)o;
        return other.proxyId == this.proxyId;
    }

    protected final AdminWrapper getWrapper() throws ConnectException {
        if (this.wrapper != null && !this.wrapper.isClosed()) {
            return this.wrapper;
        }
        return AdminModule.getWrapper();
    }

    public void setWrapper(AdminWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public final AdminReply doRequest(AdminRequest request) throws AdminException, ConnectException {
        return this.getWrapper().doRequest(request);
    }

    public static User create(String name, String password, int serverId) throws ConnectException, AdminException {
        return User.create(name, password, serverId, SimpleIdentity.class.getName());
    }

    public static User create(String name, String password) throws ConnectException, AdminException {
        return User.create(name, password, AdminModule.getLocalServerId(), SimpleIdentity.class.getName());
    }

    public static User create(String name, String password, int serverId, String identityClassName) throws ConnectException, AdminException {
        Identity identity = User.createIdentity(name, password, identityClassName);
        AdminReply reply = AdminModule.doRequest((AdminRequest)new CreateUserRequest(identity, serverId));
        User user = new User(name, ((CreateUserReply)reply).getProxId());
        return user;
    }

    public String registerMBean(String base) {
        block3: {
            if (MXWrapper.mxserver == null) {
                return null;
            }
            int sid = Integer.parseInt(this.proxyId.substring(this.proxyId.indexOf(46) + 1, this.proxyId.lastIndexOf(46)));
            StringBuffer buf = new StringBuffer();
            buf.append(base);
            buf.append(":type=User,location=server#").append(sid).append(",name=").append(this.getName()).append('[').append(this.getProxyId()).append(']');
            this.JMXBeanName = buf.toString();
            try {
                MXWrapper.registerMBean((Object)this, (String)this.JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)("User.registerMBean: " + this.JMXBeanName), (Throwable)e);
            }
        }
        return this.JMXBeanName;
    }

    public void unregisterMBean() {
        block3: {
            if (MXWrapper.mxserver == null || this.JMXBeanName == null) {
                return;
            }
            try {
                MXWrapper.unregisterMBean((String)this.JMXBeanName);
            }
            catch (Exception e) {
                if (!logger.isLoggable(BasicLevel.DEBUG)) break block3;
                logger.log(BasicLevel.DEBUG, (Object)("User.unregisterMBean: " + this.JMXBeanName), (Throwable)e);
            }
        }
    }

    private static Identity createIdentity(String user, String passwd, String identityClassName) throws AdminException {
        Identity identity = null;
        try {
            Class<?> clazz = Class.forName(identityClassName);
            identity = (Identity)clazz.newInstance();
            if (passwd != null) {
                identity.setIdentity(user, passwd);
            } else {
                identity.setUserName(user);
            }
        }
        catch (Exception e) {
            throw new AdminException(e.getMessage());
        }
        return identity;
    }

    public void update(String newName, String newPassword) throws ConnectException, AdminException {
        this.update(newName, newPassword, SimpleIdentity.class.getName());
    }

    public void update(String newName, String newPassword, String identityClassName) throws ConnectException, AdminException {
        Identity newIdentity = User.createIdentity(newName, newPassword, identityClassName);
        this.doRequest((AdminRequest)new UpdateUser(this.name, this.proxyId, newIdentity));
        this.name = newName;
    }

    public void delete() throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new DeleteUser(this.name, this.proxyId));
        this.unregisterMBean();
    }

    public void setDMQ(Queue dmq) throws ConnectException, AdminException {
        this.setDMQId(dmq.getName());
    }

    public void setDMQId(String dmqId) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetUserDMQ(this.proxyId, dmqId));
    }

    public void setThreshold(int threshold) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetUserThreshold(this.proxyId, threshold));
    }

    public DeadMQueue getDMQ() throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(this.proxyId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)this.doRequest((AdminRequest)request);
        if (reply.getDMQName() == null) {
            return null;
        }
        DeadMQueue dmq = new DeadMQueue(reply.getDMQName());
        if (this.wrapper != null) {
            dmq.setWrapper(this.wrapper);
        }
        return dmq;
    }

    public String getDMQId() throws ConnectException, AdminException {
        DeadMQueue dmq = this.getDMQ();
        if (dmq == null) {
            return null;
        }
        return dmq.getName();
    }

    public int getThreshold() throws ConnectException, AdminException {
        Monitor_GetDMQSettings request = new Monitor_GetDMQSettings(this.proxyId);
        Monitor_GetDMQSettingsRep reply = (Monitor_GetDMQSettingsRep)this.doRequest((AdminRequest)request);
        if (reply.getThreshold() == null) {
            return -1;
        }
        return reply.getThreshold();
    }

    public void setNbMaxMsg(String subName, int nbMaxMsg) throws ConnectException, AdminException {
        this.doRequest((AdminRequest)new SetNbMaxMsg(this.proxyId, nbMaxMsg, subName));
    }

    public int getNbMaxMsg(String subName) throws ConnectException, AdminException {
        Monitor_GetNbMaxMsg request = new Monitor_GetNbMaxMsg(this.proxyId, subName);
        Monitor_GetNbMaxMsgRep reply = (Monitor_GetNbMaxMsgRep)this.doRequest((AdminRequest)request);
        return reply.getNbMaxMsg();
    }

    public Subscription[] getSubscriptions() throws AdminException, ConnectException {
        GetSubscriptionsRep reply = (GetSubscriptionsRep)this.doRequest((AdminRequest)new GetSubscriptions(this.proxyId));
        String[] subNames = reply.getSubNames();
        String[] topicIds = reply.getTopicIds();
        int[] messageCounts = reply.getMessageCounts();
        boolean[] durable = reply.getDurable();
        Subscription[] res = new Subscription[subNames.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new Subscription(subNames[i], topicIds[i], messageCounts[i], durable[i]);
        }
        return res;
    }

    public List getSubscriptionList() throws AdminException, ConnectException {
        Vector<String> list = new Vector<String>();
        Subscription[] sub = this.getSubscriptions();
        for (int i = 0; i < sub.length; ++i) {
            list.add(sub[i].toString());
        }
        return list;
    }

    public Subscription getSubscription(String subName) throws AdminException, ConnectException {
        GetSubscriptionRep reply = (GetSubscriptionRep)this.doRequest((AdminRequest)new GetSubscription(this.proxyId, subName));
        Subscription sub = new Subscription(subName, reply.getTopicId(), reply.getMessageCount(), reply.getDurable());
        return sub;
    }

    public String getSubscriptionString(String subName) throws AdminException, ConnectException {
        return this.getSubscription(subName).toString();
    }

    public String[] getMessageIds(String subName) throws AdminException, ConnectException {
        GetSubscriptionMessageIdsRep reply = (GetSubscriptionMessageIdsRep)this.doRequest((AdminRequest)new GetSubscriptionMessageIds(this.proxyId, subName));
        return reply.getMessageIds();
    }

    public Message getMessage(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, true));
        return Message.wrapMomMessage(null, reply.getMessage());
    }

    public String getMessageDigest(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, true));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("Message: ").append(msg.getJMSMessageID());
        strbuf.append("\n\tTo: ").append(msg.getJMSDestination());
        strbuf.append("\n\tCorrelationId: ").append(msg.getJMSCorrelationID());
        strbuf.append("\n\tDeliveryMode: ").append(msg.getJMSDeliveryMode());
        strbuf.append("\n\tExpiration: ").append(msg.getJMSExpiration());
        strbuf.append("\n\tPriority: ").append(msg.getJMSPriority());
        strbuf.append("\n\tRedelivered: ").append(msg.getJMSRedelivered());
        strbuf.append("\n\tReplyTo: ").append(msg.getJMSReplyTo());
        strbuf.append("\n\tTimestamp: ").append(msg.getJMSTimestamp());
        strbuf.append("\n\tType: ").append(msg.getJMSType());
        return strbuf.toString();
    }

    public Properties getMessageHeader(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, false));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        prop.setProperty("JMSMessageID", msg.getJMSMessageID());
        prop.setProperty("JMSDestination", msg.getJMSDestination().toString());
        if (msg.getJMSCorrelationID() != null) {
            prop.setProperty("JMSCorrelationID", msg.getJMSCorrelationID());
        }
        prop.setProperty("JMSDeliveryMode", new Integer(msg.getJMSDeliveryMode()).toString());
        prop.setProperty("JMSExpiration", new Long(msg.getJMSExpiration()).toString());
        prop.setProperty("JMSPriority", new Integer(msg.getJMSPriority()).toString());
        prop.setProperty("JMSRedelivered", new Boolean(msg.getJMSRedelivered()).toString());
        if (msg.getJMSReplyTo() != null) {
            prop.setProperty("JMSReplyTo", msg.getJMSReplyTo().toString());
        }
        prop.setProperty("JMSTimestamp", new Long(msg.getJMSTimestamp()).toString());
        if (msg.getJMSType() != null) {
            prop.setProperty("JMSType", msg.getJMSType());
        }
        msg.getOptionalHeader(prop);
        return prop;
    }

    public Properties getMessageProperties(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        GetSubscriptionMessageRep reply = (GetSubscriptionMessageRep)this.doRequest((AdminRequest)new GetSubscriptionMessage(this.proxyId, subName, msgId, false));
        Message msg = Message.wrapMomMessage(null, reply.getMessage());
        Properties prop = new Properties();
        msg.getProperties(prop);
        return prop;
    }

    public Message readMessage(String subName, String msgId) throws AdminException, ConnectException, JMSException {
        return this.getMessage(subName, msgId);
    }

    public void deleteMessage(String subName, String msgId) throws AdminException, ConnectException {
        this.doRequest((AdminRequest)new DeleteSubscriptionMessage(this.proxyId, subName, msgId));
    }

    public void clearSubscription(String subName) throws AdminException, ConnectException {
        this.doRequest((AdminRequest)new ClearSubscription(this.proxyId, subName));
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public void toReference(Reference ref) throws NamingException {
        ref.add(new StringRefAddr("user.name", this.name));
        ref.add(new StringRefAddr("user.id", this.proxyId));
    }

    public void fromReference(Reference ref) throws NamingException {
        this.name = (String)ref.get("user.name").getContent();
        this.proxyId = (String)ref.get("user.id").getContent();
    }

    public Hashtable code() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        h.put("name", this.name);
        h.put("proxyId", this.proxyId);
        return h;
    }

    public void decode(Hashtable h) {
        this.name = (String)h.get("name");
        this.proxyId = (String)h.get("proxyId");
    }
}

