/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin.server;

import fr.dyade.aaa.agent.AgentServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.List;
import java.util.Random;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.NameAlreadyUsedException;
import org.objectweb.joram.client.jms.admin.Server;
import org.objectweb.joram.client.jms.admin.StartFailureException;
import org.objectweb.joram.client.jms.admin.UnknownServerException;
import org.objectweb.joram.client.jms.admin.User;

public class ZeroconfJoramServer {
    public static final String BASE_DIR_PATH = "org.objectweb.joram.zeroconf.baseDirPath";
    public static final String ADMIN_HOST_NAME = "org.objectweb.joram.zeroconf.adminHostName";
    public static final String ADMIN_PORT = "org.objectweb.joram.zeroconf.adminPort";
    public static final String ROOT_USER_NAME = "org.objectweb.joram.zeroconf.rootUserName";
    public static final String ROOT_USER_PWD = "org.objectweb.joram.zeroconf.rootUserPwd";
    public static final String SERVER_ID = "sid";
    public static final String JORAM_SERVER_DATA = "joramServerData";
    public static final String A3_SERVERS_XML = "a3servers.xml";
    private static String baseDirPath;
    private static File baseDir;
    private static String hostName;
    private static String serverName;

    private static void init() throws Exception {
        baseDirPath = System.getProperty(BASE_DIR_PATH, ".");
        baseDir = new File(baseDirPath);
        hostName = InetAddress.getLocalHost().getHostName();
        serverName = hostName + '/' + baseDir.getCanonicalPath();
    }

    private static void adminConnect() throws Exception {
        String adminHostName = System.getProperty(ADMIN_HOST_NAME, "localhost");
        int adminPort = Integer.getInteger(ADMIN_PORT, 16010);
        String rootUserName = System.getProperty(ROOT_USER_NAME, "root");
        String rootUserPwd = System.getProperty(ROOT_USER_PWD, "root");
        AdminModule.connect(adminHostName, adminPort, rootUserName, rootUserPwd, 60);
    }

    public static void main(String[] args) throws Exception {
        int serverId;
        ZeroconfJoramServer.init();
        try {
            serverId = ZeroconfJoramServer.loadServerId();
        }
        catch (IOException exc) {
            String domainName;
            baseDir.mkdir();
            ZeroconfJoramServer.adminConnect();
            int adminServerId = AdminModule.getLocalServerId();
            String[] domainNames = AdminModule.getDomainNames(adminServerId);
            if (domainNames.length > 0) {
                domainName = domainNames[0];
            } else {
                domainName = "D0";
                int initialDomainPort = 17000;
                int tryNb = 50;
                Random random = new Random();
                for (int i = 0; i < tryNb; ++i) {
                    try {
                        AdminModule.addDomain("D0", adminServerId, initialDomainPort + random.nextInt(tryNb) * 100);
                        break;
                    }
                    catch (NameAlreadyUsedException exc1) {
                        throw exc1;
                    }
                    catch (StartFailureException exc2) {
                        continue;
                    }
                }
            }
            ServerSocket sock1 = new ServerSocket(0);
            int port1 = sock1.getLocalPort();
            ServerSocket sock2 = new ServerSocket(0);
            int port2 = sock2.getLocalPort();
            serverId = ZeroconfJoramServer.newServerId();
            AdminModule.addServer(serverId, hostName, domainName, port1, serverName, new String[]{"org.objectweb.joram.mom.proxies.tcp.TcpProxyService"}, new String[]{String.valueOf(port2)});
            String configXml = AdminModule.getConfiguration();
            File sconfig = new File(baseDir, A3_SERVERS_XML);
            FileOutputStream fos = new FileOutputStream(sconfig);
            PrintWriter pw = new PrintWriter(fos);
            pw.println(configXml);
            pw.flush();
            fos.getFD().sync();
            pw.close();
            fos.close();
            sock1.close();
            sock2.close();
        }
        System.getProperties().put("fr.dyade.aaa.agent.A3CONF_DIR", baseDirPath);
        AgentServer.init((short)((short)serverId), (String)new File(baseDir, JORAM_SERVER_DATA).getPath(), null);
        AgentServer.start();
        User.create("anonymous", "anonymous", serverId);
        AdminModule.disconnect();
    }

    private static int newServerId() throws Exception {
        List serverIds = AdminModule.getServersIds();
        int newSid = 0;
        for (int i = 0; i < serverIds.size(); ++i) {
            Integer sid = (Integer)serverIds.get(i);
            if (newSid > sid) continue;
            newSid = sid + 1;
        }
        ZeroconfJoramServer.saveServerId(newSid);
        return newSid;
    }

    private static void saveServerId(int sid) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(baseDir, SERVER_ID));
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeInt(sid);
        oos.flush();
        fos.flush();
        fos.getFD().sync();
        fos.close();
    }

    private static int loadServerId() throws IOException {
        FileInputStream fis = new FileInputStream(new File(baseDir, SERVER_ID));
        ObjectInputStream ois = new ObjectInputStream(fis);
        int res = ois.readInt();
        fis.close();
        return res;
    }

    public static void stop() {
        AgentServer.stop();
    }

    public static void destroy() throws Exception {
        ZeroconfJoramServer.init();
        if (baseDir.exists()) {
            int serverId;
            try {
                serverId = ZeroconfJoramServer.loadServerId();
            }
            catch (IOException exc) {
                serverId = -1;
            }
            if (serverId > 0) {
                ZeroconfJoramServer.adminConnect();
                Server[] servers = AdminModule.getServers();
                for (int i = 0; i < servers.length; ++i) {
                    if (servers[i].getId() != serverId || servers[i].getName() != serverName || servers[i].getHostName() != hostName) continue;
                    try {
                        AdminModule.removeServer(serverId);
                        continue;
                    }
                    catch (UnknownServerException exc) {
                        // empty catch block
                    }
                }
            }
            new File(baseDir, SERVER_ID).delete();
            File serverDataDir = new File(baseDir, JORAM_SERVER_DATA);
            if (serverDataDir.exists()) {
                File[] files = serverDataDir.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
                serverDataDir.delete();
            }
            new File(baseDir, A3_SERVERS_XML).delete();
        }
    }
}

