/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common;

import fr.dyade.aaa.common.Debug;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Daemon
implements Runnable {
    protected volatile boolean running;
    protected volatile boolean canStop;
    protected Thread thread = null;
    private String name;
    private boolean daemon = false;
    protected int priority = 5;
    protected ThreadGroup group;
    protected Logger logmon = null;

    public synchronized boolean isRunning() {
        return this.thread != null && this.thread.isAlive();
    }

    public final String getName() {
        return this.name;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append('(').append(super.toString());
        strbuf.append(",name=").append(this.getName());
        strbuf.append(",running=").append(this.running);
        strbuf.append(",canStop=").append(this.canStop);
        strbuf.append(",thread=").append(this.thread);
        strbuf.append(')');
        return strbuf.toString();
    }

    protected Daemon(String name) {
        this(name, null);
    }

    protected Daemon(String name, Logger logmon) {
        this.name = name;
        if (logmon == null) {
            this.logmon = Debug.getLogger(this.getClass().getName() + '.' + name);
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", created."));
        } else {
            this.logmon = logmon;
        }
        this.running = false;
        this.canStop = false;
        this.thread = null;
    }

    public void setDaemon(boolean daemon) {
        if (this.running || this.thread != null && this.thread.isAlive()) {
            throw new IllegalThreadStateException("already started");
        }
        this.daemon = daemon;
    }

    public void setPriority(int newPriority) {
        if (newPriority > 10 || newPriority < 1) {
            throw new IllegalArgumentException();
        }
        if (this.running && this.thread != null && this.thread.isAlive()) {
            this.thread.setPriority(newPriority);
        }
        this.priority = newPriority;
    }

    public void setThreadGroup(ThreadGroup group) {
        if (this.running || this.thread != null && this.thread.isAlive()) {
            throw new IllegalThreadStateException("already started");
        }
        this.group = group;
    }

    public synchronized void start() {
        if (this.thread != null && this.thread.isAlive()) {
            if (this.logmon.isLoggable(BasicLevel.WARN)) {
                this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", already started."));
            }
            throw new IllegalThreadStateException("already started");
        }
        this.thread = new Thread(this.group, this, this.getName());
        this.thread.setDaemon(this.daemon);
        if (this.priority != 5) {
            this.thread.setPriority(this.priority);
        }
        this.running = true;
        this.canStop = true;
        this.thread.start();
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", started."));
        }
    }

    protected abstract void close();

    protected abstract void shutdown();

    public void interrupt() {
        this.thread.interrupt();
    }

    protected final void finish() {
        this.running = false;
        this.close();
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", ended"));
        }
    }

    public synchronized void stop() {
        if (this.logmon.isLoggable(BasicLevel.DEBUG)) {
            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", stops."));
        }
        this.running = false;
        if (Thread.currentThread() == this.thread) {
            return;
        }
        if (this.thread != null) {
            while (this.thread.isAlive()) {
                if (this.canStop) {
                    if (this.thread.isAlive()) {
                        this.thread.interrupt();
                    }
                    this.shutdown();
                }
                try {
                    this.thread.join(1000L);
                }
                catch (InterruptedException exc) {}
            }
            this.finish();
            this.thread = null;
        }
    }

    public boolean isCurrentThread() {
        return this.thread != null && this.thread == Thread.currentThread();
    }

    public void setName(String name) {
        this.thread.setName(name);
    }
}

