/*
 * Decompiled with CFR 0.152.
 */
package com.scalagent.jmx;

import fr.dyade.aaa.util.management.MXServer;
import fr.dyade.aaa.util.management.MXWrapper;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;

public class JMXServer
implements MXServer,
Serializable {
    public MBeanServer mxserver = null;

    public JMXServer(MBeanServer mxserver) {
        this.mxserver = mxserver;
        MXWrapper.setMXServer(this);
    }

    public JMXServer() {
        try {
            Class<?> clazz = Class.forName("java.lang.management.ManagementFactory");
            Method method = clazz.getMethod("getPlatformMBeanServer", null);
            this.mxserver = (MBeanServer)method.invoke(null, null);
        }
        catch (Exception exc) {
            this.mxserver = MBeanServerFactory.createMBeanServer("AgentServer");
        }
        MXWrapper.setMXServer(this);
    }

    public void registerMBean(Object bean, String domain, String name) throws Exception {
        if (this.mxserver == null) {
            return;
        }
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(domain);
        if (name != null) {
            strbuf.append(':').append(name);
        }
        try {
            this.mxserver.registerMBean(bean, new ObjectName(strbuf.toString()));
        }
        catch (InstanceAlreadyExistsException exc) {
            throw exc;
        }
        catch (MBeanRegistrationException exc) {
            throw exc;
        }
        catch (NotCompliantMBeanException exc) {
            throw exc;
        }
        catch (RuntimeOperationsException exc) {
            throw exc;
        }
    }

    public void unregisterMBean(String domain, String name) throws Exception {
        if (this.mxserver == null) {
            return;
        }
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(domain);
        strbuf.append(':').append(name);
        try {
            this.mxserver.unregisterMBean(new ObjectName(strbuf.toString()));
        }
        catch (InstanceNotFoundException exc) {
            throw exc;
        }
        catch (MBeanRegistrationException exc) {
            throw exc;
        }
        catch (RuntimeOperationsException exc) {
            throw exc;
        }
    }
}

