/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.selectors;

import java.util.StringTokenizer;
import org.objectweb.joram.shared.messages.Message;

class Interpreter {
    Interpreter() {
    }

    static Object interpret(String name, Message message, String syntaxType) {
        if (syntaxType.equals("JMS")) {
            return Interpreter.jmsInterpret(name, message);
        }
        return null;
    }

    public static String wrapToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        return value.toString();
    }

    private static Object jmsInterpret(String name, Message message) {
        Object value = null;
        value = name.equals("JMSMessageID") ? message.id : (name.equals("JMSPriority") ? new Integer(message.priority) : (name.equals("JMSTimestamp") ? new Long(message.timestamp) : (name.equals("JMSCorrelationID") ? message.correlationId : (name.equals("JMSDeliveryMode") ? (message.persistent ? "PERSISTENT" : "NON_PERSISTENT") : (name.equals("JMSType") ? Interpreter.wrapToString(message.getOptionalHeader("JMSType")) : (name.startsWith("JMSX") ? (name.equals("JMSXDeliveryCounts") ? new Integer(message.deliveryCount) : message.getOptionalHeader(name)) : (name.equals("JMS_JORAM_DELETEDDEST") ? new Boolean(message.deletedDest) : (name.equals("JMS_JORAM_NOTWRITEABLE") ? new Boolean(message.notWriteable) : (name.equals("JMS_JORAM_EXPIRED") ? new Boolean(message.expired) : (name.equals("JMS_JORAM_UNDELIVERABLE") ? new Boolean(message.undeliverable) : message.getProperty(name)))))))))));
        if (value instanceof String) {
            StringTokenizer tokenizer = new StringTokenizer((String)value, "'");
            StringBuffer buff = new StringBuffer();
            while (tokenizer.hasMoreTokens()) {
                buff.append(tokenizer.nextToken());
                buff.append("''");
            }
            String s = buff.toString();
            value = s.substring(0, s.length() - 2);
        } else if (value instanceof Number) {
            value = new Double(((Number)value).doubleValue());
        }
        return value;
    }
}

