/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.security;

import fr.dyade.aaa.common.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Hashtable;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.joram.shared.stream.Streamable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public abstract class Identity
implements Externalizable,
Streamable {
    public static Logger logger = Debug.getLogger((String)Identity.class.getName());
    private static final String SEPARATE_CHAR = ":";

    public abstract String getUserName();

    public abstract void setUserName(String var1);

    public abstract void setIdentity(String var1, String var2) throws Exception;

    public abstract boolean check(Identity var1) throws Exception;

    public static String getRootIdentityClass(String rootName) {
        String identityClassName = null;
        int index = rootName.indexOf(SEPARATE_CHAR);
        identityClassName = index > 0 ? rootName.substring(0, index) : SimpleIdentity.class.getName();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("getRootIdentityClass: identityClassName = " + identityClassName));
        }
        return identityClassName;
    }

    public static String getRootName(String rootName) {
        String root = rootName;
        int index = rootName.indexOf(SEPARATE_CHAR);
        if (index > 0) {
            root = root.substring(index + 1, rootName.length());
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("getRootName: rootName = " + root));
        }
        return root;
    }

    public Hashtable soapCode() throws IOException {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        h.put("classname", this.getClass().getName());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(baos);
        baos.flush();
        h.put("bytecontent", baos.toByteArray());
        baos.close();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object soapDecode(Hashtable h) throws Exception {
        Identity identity = null;
        ByteArrayInputStream bais = null;
        try {
            String classname = (String)h.get("classname");
            identity = (Identity)Class.forName(classname).newInstance();
            byte[] content = (byte[])h.get("bytecontent");
            bais = new ByteArrayInputStream(content);
            identity.readFrom(bais);
        }
        finally {
            bais.close();
        }
        return identity;
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Identity.writeExternal");
        }
        this.writeTo((OutputStream)((Object)out));
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"Identity.readExternal");
        }
        this.readFrom((InputStream)((Object)in));
    }

    public static void write(Identity identity, OutputStream os) throws IOException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Identity.write: " + identity));
        }
        if (identity == null) {
            StreamUtil.writeTo((String)null, os);
            return;
        }
        if (identity instanceof SimpleIdentity) {
            StreamUtil.writeTo("", os);
        } else {
            StreamUtil.writeTo(identity.getClass().getName(), os);
        }
        identity.writeTo(os);
    }

    public static Identity read(InputStream is) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Identity identity = null;
        String classname = StreamUtil.readStringFrom(is);
        if (classname != null) {
            if (classname.length() == 0) {
                classname = SimpleIdentity.class.getName();
            }
            identity = (Identity)Class.forName(classname).newInstance();
            identity.readFrom(is);
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("Identity.read: " + identity));
        }
        return identity;
    }
}

