/**
 * **********************************************************************
 *
 * <p>DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * <p>Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * <p>Use is subject to license terms.
 *
 * <p>Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0. You can also obtain a copy of the License at
 * http://odftoolkit.org/docs/license.txt
 *
 * <p>Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied.
 *
 * <p>See the License for the specific language governing permissions and limitations under the
 * License.
 *
 * <p>**********************************************************************
 */

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.DefaultElementVisitor;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.attribute.text.TextIsListHeaderAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextOutlineLevelAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextRestartNumberingAttribute;
import org.odftoolkit.odfdom.dom.attribute.text.TextStartValueAttribute;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

/** DOM implementation of OpenDocument element {@odf.element text:h}. */
public class TextHElement extends TextParagraphElementBase {

  public static final OdfName ELEMENT_NAME = OdfName.newName(OdfDocumentNamespace.TEXT, "h");

  /**
   * Create the instance of <code>TextHElement</code>
   *
   * @param ownerDoc The type is <code>OdfFileDom</code>
   */
  public TextHElement(OdfFileDom ownerDoc) {
    super(
        ownerDoc,
        ELEMENT_NAME,
        OdfStyleFamily.Paragraph,
        OdfName.newName(OdfDocumentNamespace.TEXT, "style-name"));
  }

  /**
   * Get the element name
   *
   * @return return <code>OdfName</code> the name of element {@odf.element text:h}.
   */
  public OdfName getOdfName() {
    return ELEMENT_NAME;
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextIsListHeaderAttribute
   * </code> , See {@odf.attribute text:is-list-header}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getTextIsListHeaderAttribute() {
    TextIsListHeaderAttribute attr =
        (TextIsListHeaderAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "is-list-header");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(TextIsListHeaderAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextIsListHeaderAttribute</code> , See
   * {@odf.attribute text:is-list-header}
   *
   * @param textIsListHeaderValue The type is <code>Boolean</code>
   */
  public void setTextIsListHeaderAttribute(Boolean textIsListHeaderValue) {
    TextIsListHeaderAttribute attr = new TextIsListHeaderAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(textIsListHeaderValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextOutlineLevelAttribute
   * </code> , See {@odf.attribute text:outline-level}
   *
   * <p>Attribute is mandatory.
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getTextOutlineLevelAttribute() {
    TextOutlineLevelAttribute attr =
        (TextOutlineLevelAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "outline-level");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextOutlineLevelAttribute</code> , See
   * {@odf.attribute text:outline-level}
   *
   * @param textOutlineLevelValue The type is <code>Integer</code>
   */
  public void setTextOutlineLevelAttribute(Integer textOutlineLevelValue) {
    TextOutlineLevelAttribute attr = new TextOutlineLevelAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(textOutlineLevelValue.intValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextRestartNumberingAttribute
   * </code> , See {@odf.attribute text:restart-numbering}
   *
   * @return - the <code>Boolean</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Boolean getTextRestartNumberingAttribute() {
    TextRestartNumberingAttribute attr =
        (TextRestartNumberingAttribute)
            getOdfAttribute(OdfDocumentNamespace.TEXT, "restart-numbering");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Boolean.valueOf(attr.booleanValue());
    }
    return Boolean.valueOf(TextRestartNumberingAttribute.DEFAULT_VALUE);
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextRestartNumberingAttribute</code> ,
   * See {@odf.attribute text:restart-numbering}
   *
   * @param textRestartNumberingValue The type is <code>Boolean</code>
   */
  public void setTextRestartNumberingAttribute(Boolean textRestartNumberingValue) {
    TextRestartNumberingAttribute attr =
        new TextRestartNumberingAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setBooleanValue(textRestartNumberingValue.booleanValue());
  }

  /**
   * Receives the value of the ODFDOM attribute representation <code>TextStartValueAttribute</code>
   * , See {@odf.attribute text:start-value}
   *
   * @return - the <code>Integer</code> , the value or <code>null</code>, if the attribute is not
   *     set and no default value defined.
   */
  public Integer getTextStartValueAttribute() {
    TextStartValueAttribute attr =
        (TextStartValueAttribute) getOdfAttribute(OdfDocumentNamespace.TEXT, "start-value");
    if (attr != null && !attr.getValue().isEmpty()) {
      return Integer.valueOf(attr.intValue());
    }
    return null;
  }

  /**
   * Sets the value of ODFDOM attribute representation <code>TextStartValueAttribute</code> , See
   * {@odf.attribute text:start-value}
   *
   * @param textStartValueValue The type is <code>Integer</code>
   */
  public void setTextStartValueAttribute(Integer textStartValueValue) {
    TextStartValueAttribute attr = new TextStartValueAttribute((OdfFileDom) this.ownerDocument);
    setOdfAttribute(attr);
    attr.setIntValue(textStartValueValue.intValue());
  }

  /**
   * Create child element {@odf.element text:number}.
   *
   * @return the element {@odf.element text:number}
   */
  public TextNumberElement newTextNumberElement() {
    TextNumberElement textNumber =
        ((OdfFileDom) this.ownerDocument).newOdfElement(TextNumberElement.class);
    this.appendChild(textNumber);
    return textNumber;
  }

  /**
   * Accept an visitor instance to allow the visitor to do some operations. Refer to visitor design
   * pattern to get a better understanding.
   *
   * @param visitor an instance of DefaultElementVisitor
   */
  @Override
  public void accept(ElementVisitor visitor) {
    if (visitor instanceof DefaultElementVisitor) {
      DefaultElementVisitor defaultVisitor = (DefaultElementVisitor) visitor;
      defaultVisitor.visit(this);
    } else {
      visitor.visit(this);
    }
  }

  /** Add text content. Only elements which are allowed to have text content offer this method. */
  public void newTextNode(String content) {
    if (content != null && !content.equals("")) {
      this.appendChild(this.getOwnerDocument().createTextNode(content));
    }
  }

  /**
   * Replaces all content with given text content. Only elements which are allowed to have text
   * content offer this method.
   *
   * @param new text content to replace the existing children (or removes all if null)
   */
  @Override
  public void setTextContent(String content) {
    super.setTextContent(content);
    ((OdfFileDom) this.ownerDocument).updateInContentMetadataCache(this);
  }

  @Override
  protected void onRemoveNode() {
    super.onRemoveNode();
    ((OdfFileDom) this.ownerDocument).getInContentMetadataCache().remove(this);
  }

  @Override
  protected void onInsertNode() {
    super.onInsertNode();
    ((OdfFileDom) this.ownerDocument).updateInContentMetadataCache(this);
  }

  @Override
  public boolean isComponentRoot() {
    return true;
  }

  /**
   * Splitting the element at the given position into two halves
   *
   * <p>If the paragraph does have an automatic style with a master-page, which results into a page
   * break before the paragraph, this page break will be removed for the new second half. For
   * paragraph containing template styles the follow-up style should be chosen.
   *
   * @param posStart The logical position of the first character (or other paragraph child
   *     component) that will be moved to the beginning of the new paragraph.
   * @return the new created second text container
   */
  @Override
  public OdfElement split(int posStart) {
    TextParagraphElementBase newSecondElement = (TextParagraphElementBase) super.split(posStart);
    OdfStyle autoStyle = newSecondElement.getAutomaticStyle();

    if (autoStyle != null) {
      OdfStylePropertiesBase paragraphProps =
          autoStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
      if (autoStyle.getStyleMasterPageNameAttribute() != null || paragraphProps != null) {
        StyleStyleElement newStyle = newSecondElement.getOrCreateUnqiueAutomaticStyle();
        if (autoStyle.getStyleMasterPageNameAttribute() != null) {
          newStyle.removeAttributeNS(OdfDocumentNamespace.STYLE.getUri(), "master-page-name");
        }
        // overwrite the paragraph properties from the source one, with the cloned element's
        paragraphProps = newStyle.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties);
        // no paragraph page break should be inherited
        if (paragraphProps != null) {
          paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-before");
          paragraphProps.removeAttributeNS(OdfDocumentNamespace.FO.getUri(), "break-after");
        }
      }
    }
    return newSecondElement;
  }
}
