/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008, 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.OdfName;
import org.odftoolkit.odfdom.OdfNamespace;
import org.odftoolkit.odfdom.OdfFileDom;
import org.odftoolkit.odfdom.dom.OdfNamespaceNames;
import org.odftoolkit.odfdom.OdfElement;
import org.odftoolkit.odfdom.dom.attribute.table.TableNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableSourceNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableObjectNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TableUserNameAttribute;
import org.odftoolkit.odfdom.dom.attribute.table.TablePasswordAttribute;


/**
 * DOM implementation of OpenDocument element  {@odf.element table:source-service}.
 *
 */
public class TableSourceServiceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.newName(OdfNamespaceNames.TABLE, "source-service" );


	/**
	 * Create the instance of <code>TableSourceServiceElement</code> 
	 *
	 * @param  ownerDoc     The type is <code>OdfFileDom</code>
	 */
	public TableSourceServiceElement( OdfFileDom ownerDoc )
	{
		super( ownerDoc, ELEMENT_NAME	);
	}

	/**
	 * Get the element name 
	 *
	 * @return  return   <code>OdfName</code> the name of element {@odf.element table:source-service}.
	 */
	public OdfName getOdfName()
	{
		return ELEMENT_NAME;
	}

	/**
	 * Initialization of the mandatory attributes of {@link  TableSourceServiceElement}
	 *
     * @param tableNameAttributeValue  The mandatory attribute {@odf.attribute  table:name}"
     * @param tableSourceNameAttributeValue  The mandatory attribute {@odf.attribute  table:source-name}"
     * @param tableObjectNameAttributeValue  The mandatory attribute {@odf.attribute  table:object-name}"
     *
	 */
	public void init(String tableNameAttributeValue, String tableSourceNameAttributeValue, String tableObjectNameAttributeValue)
	{
		setTableSourceNameAttribute( tableSourceNameAttributeValue );
		setTableObjectNameAttribute( tableObjectNameAttributeValue );
	}

	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableNameAttribute</code> , See {@odf.attribute table:name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableNameAttribute()
	{
		TableNameAttribute attr = (TableNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableNameAttribute</code> , See {@odf.attribute table:name}
	 *
	 * @param tableNameValue   The type is <code>String</code>
	 */
	public void setTableNameAttribute( String tableNameValue )
	{
		TableNameAttribute attr =  new TableNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableSourceNameAttribute</code> , See {@odf.attribute table:source-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableSourceNameAttribute()
	{
		TableSourceNameAttribute attr = (TableSourceNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "source-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableSourceNameAttribute</code> , See {@odf.attribute table:source-name}
	 *
	 * @param tableSourceNameValue   The type is <code>String</code>
	 */
	public void setTableSourceNameAttribute( String tableSourceNameValue )
	{
		TableSourceNameAttribute attr =  new TableSourceNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableSourceNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableObjectNameAttribute</code> , See {@odf.attribute table:object-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableObjectNameAttribute()
	{
		TableObjectNameAttribute attr = (TableObjectNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "object-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableObjectNameAttribute</code> , See {@odf.attribute table:object-name}
	 *
	 * @param tableObjectNameValue   The type is <code>String</code>
	 */
	public void setTableObjectNameAttribute( String tableObjectNameValue )
	{
		TableObjectNameAttribute attr =  new TableObjectNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableObjectNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TableUserNameAttribute</code> , See {@odf.attribute table:user-name}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTableUserNameAttribute()
	{
		TableUserNameAttribute attr = (TableUserNameAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "user-name" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TableUserNameAttribute</code> , See {@odf.attribute table:user-name}
	 *
	 * @param tableUserNameValue   The type is <code>String</code>
	 */
	public void setTableUserNameAttribute( String tableUserNameValue )
	{
		TableUserNameAttribute attr =  new TableUserNameAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tableUserNameValue );
	}


	/**
	 * Receives the value of the ODFDOM attribute representation <code>TablePasswordAttribute</code> , See {@odf.attribute table:password}
	 *
	 * @return - the <code>String</code> , the value or <code>null</code>, if the attribute is not set and no default value defined.
	 */
	public String getTablePasswordAttribute()
	{
		TablePasswordAttribute attr = (TablePasswordAttribute) getOdfAttribute( OdfNamespace.newNamespace(OdfNamespaceNames.TABLE), "password" ) ;
		if( attr != null ){
			return String.valueOf( attr.getValue() );
		}
		return null;
	}
		 
	/**
	 * Sets the value of ODFDOM attribute representation <code>TablePasswordAttribute</code> , See {@odf.attribute table:password}
	 *
	 * @param tablePasswordValue   The type is <code>String</code>
	 */
	public void setTablePasswordAttribute( String tablePasswordValue )
	{
		TablePasswordAttribute attr =  new TablePasswordAttribute( (OdfFileDom)this.ownerDocument );
		setOdfAttribute( attr );
		attr.setValue( tablePasswordValue );
	}

}
