/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.core.util.StringUtil;
import org.openapi4j.parser.model.v3.Server;

public class PathResolver {
    private static final Pattern OAS_PATH_PARAMETERS_PATTERN = Pattern.compile("\\{[.;?*+]*([^{}.;?*+]+)[^}]*}");
    private static final Pattern ABSOLUTE_URL_PATTERN = Pattern.compile("\\A[a-z0-9.+-]+://.*", 2);
    private static final Pattern PATH_URL_PATTERN = Pattern.compile("(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\\?([^#]*))?(?:#(.*))?");
    private static final String START_STRING_ANCHOR = "^";
    private static final String END_STRING_ANCHOR = "$";
    private static final String START_PARAM_NAMED_GROUP = "(?<";
    private static final String END_PARAM_NAMED_GROUP = ">[^\\/]+)";
    private static final PathResolver INSTANCE = new PathResolver();

    private PathResolver() {
    }

    public static PathResolver instance() {
        return INSTANCE;
    }

    public Pattern solve(String templatePath) {
        return this.solve(templatePath, EnumSet.of(Options.NONE));
    }

    public Pattern solve(String templatePath, Set<Options> options) {
        StringBuilder regex = new StringBuilder();
        int lastMatchEnd = 0;
        boolean foundParameter = false;
        Matcher parametersMatcher = OAS_PATH_PARAMETERS_PATTERN.matcher(templatePath);
        while (parametersMatcher.find()) {
            this.addConstantFragment(regex, templatePath, lastMatchEnd, parametersMatcher.start());
            lastMatchEnd = parametersMatcher.end();
            String paramName = parametersMatcher.group(1);
            this.addVariableFragment(regex, paramName);
            foundParameter = true;
        }
        if (foundParameter) {
            this.addConstantFragment(regex, templatePath, lastMatchEnd, templatePath.length());
            this.setupAnchors(regex, options);
            return Pattern.compile(regex.toString());
        }
        if (options.contains((Object)Options.RETURN_FIXED_PATTERN)) {
            regex.append(Pattern.quote(templatePath));
            this.setupAnchors(regex, options);
            return Pattern.compile(regex.toString());
        }
        return null;
    }

    public String getResolvedPath(OAIContext context, String url) {
        try {
            if (this.isAbsoluteUrl(url)) {
                Matcher m = PATH_URL_PATTERN.matcher(url);
                return m.find() ? m.group(3) : "/";
            }
            URL resource = context.getBaseUrl();
            String basePath = (String)StringUtil.tokenize((String)resource.toString(), (String)"(?:\\?.*|#.*)", (boolean)false, (boolean)true).get(0);
            String host = resource.getHost();
            if (host.length() > 0 && basePath.endsWith(host)) {
                return "/";
            }
            String lastFragment = basePath.substring(basePath.lastIndexOf(47) + 1);
            if (lastFragment.contains(".")) {
                basePath = basePath.substring(0, basePath.indexOf(lastFragment));
            }
            return new URL(new URL(basePath), url).getPath();
        }
        catch (MalformedURLException e) {
            return "/";
        }
    }

    public List<Pattern> buildPathPatterns(OAIContext context, List<Server> servers, String templatePath) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        if (servers == null) {
            patterns.add(this.buildPathPattern("", templatePath));
        } else {
            for (Server server : servers) {
                Pattern pattern = this.buildPathPattern(this.getResolvedPath(context, server.getUrl()), templatePath);
                patterns.add(pattern);
            }
        }
        return patterns;
    }

    public Pattern findPathPattern(Collection<Pattern> pathPatterns, String requestPath) {
        if (requestPath == null || requestPath.isEmpty()) {
            requestPath = "/";
        }
        for (Pattern pathPattern : pathPatterns) {
            Matcher matcher = pathPattern.matcher(requestPath);
            if (!matcher.matches()) continue;
            return pathPattern;
        }
        return null;
    }

    public String getParamGroupName(String paramName) {
        return paramName.replaceAll("[^a-zA-Z]", "") + Math.abs(paramName.hashCode());
    }

    private Pattern buildPathPattern(String basePath, String templatePath) {
        return this.solve(basePath + templatePath, EnumSet.of(Options.START_STRING, Options.END_STRING, Options.RETURN_FIXED_PATTERN));
    }

    private void setupAnchors(StringBuilder regex, Set<Options> options) {
        if (options.contains((Object)Options.START_STRING)) {
            regex.insert(0, START_STRING_ANCHOR);
        }
        if (options.contains((Object)Options.END_STRING)) {
            regex.append(END_STRING_ANCHOR);
        }
    }

    private boolean isAbsoluteUrl(String url) {
        return ABSOLUTE_URL_PATTERN.matcher(url).matches();
    }

    private void addVariableFragment(StringBuilder regex, String paramName) {
        regex.append(START_PARAM_NAMED_GROUP).append(this.getParamGroupName(paramName)).append(END_PARAM_NAMED_GROUP);
    }

    private void addConstantFragment(StringBuilder regex, String oasPath, int beginIndex, int endIndex) {
        String toQuote = oasPath.substring(beginIndex, endIndex);
        if (toQuote.length() != 0) {
            regex.append(Pattern.quote(toQuote));
        }
    }

    public static enum Options {
        NONE,
        START_STRING,
        END_STRING,
        RETURN_FIXED_PATTERN;

    }
}

