/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.convert;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.operation.validator.util.PathResolver;
import org.openapi4j.operation.validator.util.convert.ContentConverter;
import org.openapi4j.operation.validator.util.convert.FormUrlConverter;
import org.openapi4j.operation.validator.util.convert.style.LabelStyleConverter;
import org.openapi4j.operation.validator.util.convert.style.MatrixStyleConverter;
import org.openapi4j.operation.validator.util.convert.style.SimpleStyleConverter;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.Parameter;

public final class ParameterConverter {
    private static final String LABEL = "label";
    private static final String MATRIX = "matrix";

    private ParameterConverter() {
    }

    public static Map<String, JsonNode> pathToNode(OAIContext context, Map<String, AbsParameter<Parameter>> specParameters, Pattern pattern, String path) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (pattern == null) {
            return mappedValues;
        }
        Matcher matcher = pattern.matcher(path);
        if (!matcher.matches()) {
            return mappedValues;
        }
        for (Map.Entry<String, AbsParameter<Parameter>> paramEntry : specParameters.entrySet()) {
            String style;
            String paramName = paramEntry.getKey();
            AbsParameter<Parameter> param = paramEntry.getValue();
            String paramGroupName = PathResolver.instance().getParamGroupName(paramName);
            JsonNode convertedValue = param.getSchema() != null ? (LABEL.equals(style = param.getStyle()) ? LabelStyleConverter.instance().convert(context, param, paramName, matcher.group(paramGroupName)) : (MATRIX.equals(style) ? MatrixStyleConverter.instance().convert(context, param, paramName, matcher.group(paramGroupName)) : SimpleStyleConverter.instance().convert(context, param, paramName, matcher.group(paramGroupName)))) : ParameterConverter.getValueFromContentType(context, param.getContentMediaTypes(), matcher.group(paramGroupName));
            mappedValues.put(paramName, convertedValue);
        }
        return mappedValues;
    }

    public static Map<String, JsonNode> queryToNode(OAIContext context, Map<String, AbsParameter<Parameter>> specParameters, String rawValue, String encoding) {
        return FormUrlConverter.instance().convert(context, specParameters, rawValue, false, encoding);
    }

    public static <M extends OpenApiSchema<M>> Map<String, JsonNode> headersToNode(OAIContext context, Map<String, AbsParameter<M>> specParameters, Map<String, Collection<String>> headers) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (headers == null) {
            return mappedValues;
        }
        for (Map.Entry<String, AbsParameter<M>> paramEntry : specParameters.entrySet()) {
            Collection<String> headerValues;
            String paramName = paramEntry.getKey();
            AbsParameter<M> param = paramEntry.getValue();
            Object convertedValue = !headers.containsKey(paramName) ? null : ((headerValues = headers.get(paramName)) != null ? (param.getSchema() != null ? SimpleStyleConverter.instance().convert(context, param, paramName, String.join((CharSequence)",", headerValues)) : ParameterConverter.getValueFromContentType(context, param.getContentMediaTypes(), headerValues.stream().findFirst().orElse(null))) : JsonNodeFactory.instance.nullNode());
            if (convertedValue == null) continue;
            mappedValues.put(paramName, (JsonNode)convertedValue);
        }
        return mappedValues;
    }

    public static Map<String, JsonNode> cookiesToNode(OAIContext context, Map<String, AbsParameter<Parameter>> specParameters, Map<String, String> cookies) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (cookies == null) {
            return mappedValues;
        }
        for (Map.Entry<String, AbsParameter<Parameter>> paramEntry : specParameters.entrySet()) {
            String value;
            String paramName = paramEntry.getKey();
            AbsParameter<Parameter> param = paramEntry.getValue();
            if (param.getExplode() == null) {
                param.setExplode(Boolean.valueOf(true));
            }
            Object convertedValue = !cookies.containsKey(paramName) ? null : ((value = cookies.get(paramName)) != null ? (param.getSchema() != null ? SimpleStyleConverter.instance().convert(context, param, paramName, value) : ParameterConverter.getValueFromContentType(context, param.getContentMediaTypes(), value)) : JsonNodeFactory.instance.nullNode());
            if (convertedValue == null) continue;
            mappedValues.put(paramName, (JsonNode)convertedValue);
        }
        return mappedValues;
    }

    private static JsonNode getValueFromContentType(OAIContext context, Map<String, MediaType> mediaTypes, String value) {
        Optional entry;
        if (mediaTypes != null && value != null && (entry = mediaTypes.entrySet().stream().findFirst()).isPresent()) {
            Map.Entry mediaType = (Map.Entry)entry.get();
            try {
                return ContentConverter.convert(context, (MediaType)mediaType.getValue(), (String)mediaType.getKey(), null, value);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

