/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.validation;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.core.validation.ValidationResult;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class ParameterValidator<M extends OpenApiSchema<M>> {
    private static final ValidationResult PARAM_REQUIRED_ERR = new ValidationResult(ValidationSeverity.ERROR, Integer.valueOf(206), "Parameter '%s' is required.");
    private final ValidationContext<OAI3> context;
    private final Map<String, JsonValidator> specValidators;
    private final Map<String, AbsParameter<M>> specParameters;

    ParameterValidator(ValidationContext<OAI3> context, Map<String, AbsParameter<M>> specParameters) {
        this.context = context;
        this.specParameters = specParameters;
        this.specValidators = this.initValidators(specParameters);
    }

    Map<String, AbsParameter<M>> getParameters() {
        return this.specParameters;
    }

    void validate(Map<String, JsonNode> values, ValidationData<?> validation) {
        if (this.specValidators == null) {
            return;
        }
        for (Map.Entry<String, JsonValidator> entry : this.specValidators.entrySet()) {
            String paramName = entry.getKey();
            if (!this.checkRequired(paramName, this.specParameters.get(paramName), values, validation)) continue;
            JsonNode paramValue = values.get(paramName);
            entry.getValue().validate(paramValue, validation);
        }
    }

    private Map<String, JsonValidator> initValidators(Map<String, AbsParameter<M>> specParameters) {
        if (specParameters == null || specParameters.isEmpty()) {
            return null;
        }
        HashMap<String, JsonValidator> validators = new HashMap<String, JsonValidator>();
        for (Map.Entry<String, AbsParameter<M>> paramEntry : specParameters.entrySet()) {
            String paramName = paramEntry.getKey();
            AbsParameter<M> parameter = paramEntry.getValue();
            Schema paramSchema = null;
            if (parameter.getContentMediaTypes() != null) {
                Iterator iterator = parameter.getContentMediaTypes().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    MediaType mediaType = (MediaType)entry.getValue();
                    paramSchema = mediaType.getSchema();
                }
            } else {
                paramSchema = parameter.getSchema();
            }
            if (paramSchema == null) continue;
            SchemaValidator validator = new SchemaValidator(this.context, paramName, (JsonNode)TreeUtil.json.convertValue((Object)paramSchema.copy(), JsonNode.class));
            validators.put(paramName, (JsonValidator)validator);
        }
        return validators.size() != 0 ? validators : null;
    }

    private boolean checkRequired(String paramName, AbsParameter<?> parameter, Map<String, JsonNode> paramValues, ValidationData<?> validation) {
        if (!paramValues.containsKey(paramName)) {
            if (parameter.isRequired()) {
                validation.add(PARAM_REQUIRED_ERR, new Object[]{paramName});
            }
            return false;
        }
        return true;
    }
}

