/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.schema.validator.v3;

import com.fasterxml.jackson.databind.JsonNode;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.schema.validator.BaseJsonValidator;
import org.openapi4j.schema.validator.JsonValidator;
import org.openapi4j.schema.validator.ValidationContext;
import org.openapi4j.schema.validator.ValidationData;
import org.openapi4j.schema.validator.v3.SchemaValidator;

class ReferenceValidator
extends BaseJsonValidator<OAI3> {
    private static final String HASH = "#";
    private final String refValue;
    private JsonValidator schemaValidator;

    ReferenceValidator(ValidationContext<OAI3> context, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        if (HASH.equals(schemaNode.textValue())) {
            this.refValue = schemaNode.textValue();
            this.schemaValidator = parentSchema.findParent();
        } else {
            JsonNode refNode = schemaParentNode.has("abs$ref") ? schemaParentNode.get("abs$ref") : schemaNode;
            this.refValue = refNode.textValue();
            Reference reference = context.getContext().getReferenceRegistry().getRef(this.refValue);
            JsonValidator validator = context.getReference(this.refValue);
            if (validator == null) {
                ReferenceValidator refValidator = new ReferenceValidator(context, this.refValue, schemaNode, schemaParentNode, parentSchema);
                refValidator.setSchemaValidator(new SchemaValidator(context, new ValidationResults.CrumbInfo(schemaNode.textValue(), true), reference.getContent(), schemaParentNode, parentSchema));
                this.schemaValidator = refValidator;
            } else {
                this.schemaValidator = validator;
            }
        }
    }

    private ReferenceValidator(ValidationContext<OAI3> context, String refValue, JsonNode schemaNode, JsonNode schemaParentNode, SchemaValidator parentSchema) {
        super(context, schemaNode, schemaParentNode, parentSchema);
        this.refValue = refValue;
        context.addReference(refValue, this);
    }

    private void setSchemaValidator(JsonValidator schemaValidator) {
        this.schemaValidator = schemaValidator;
    }

    @Override
    public boolean validate(JsonNode valueNode, ValidationData<?> validation) {
        this.schemaValidator.validate(valueNode, validation);
        return false;
    }
}

