/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.CommunicationRequest;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class CommunicationRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public CommunicationRequestResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public CommunicationRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        CommunicationRequest communicationRequest = new CommunicationRequest();
        communicationRequest.setStatus(CommunicationRequest.CommunicationRequestStatus.DRAFT);
        communicationRequest.setSubject(new Reference(request.getSubjectId()));
        if (request.hasEncounterId().booleanValue()) {
            communicationRequest.setContext(new Reference(request.getEncounterId()));
        }
        if (request.hasPractitionerId().booleanValue()) {
            communicationRequest.setRequester(new CommunicationRequest.CommunicationRequestRequesterComponent(new Reference(request.getPractitionerId())));
        }
        if (this.activityDefinition.hasCode() && this.activityDefinition.getCode().hasText()) {
            communicationRequest.addPayload().setContent((Type)new StringType(this.activityDefinition.getCode().getText()));
        }
        return communicationRequest;
    }
}

