/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.dstu3;

import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.SupplyRequest;
import org.hl7.fhir.dstu3.model.Type;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class SupplyRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public SupplyRequestResolver(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public SupplyRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        SupplyRequest supplyRequest = new SupplyRequest();
        if (request.hasPractitionerId().booleanValue()) {
            supplyRequest.setRequester(new SupplyRequest.SupplyRequestRequesterComponent(new Reference(request.getPractitionerId())));
        }
        if (request.hasOrganizationId().booleanValue()) {
            supplyRequest.setRequester(new SupplyRequest.SupplyRequestRequesterComponent(new Reference(request.getOrganizationId())));
        }
        if (this.activityDefinition.hasCode()) {
            supplyRequest.setOrderedItem(new SupplyRequest.SupplyRequestOrderedItemComponent((Quantity)this.activityDefinition.getQuantity()).setItem((Type)this.activityDefinition.getCode()));
        }
        return supplyRequest;
    }
}

