/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r4;

import com.google.common.base.Preconditions;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.Reference;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class AppointmentResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public AppointmentResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public Appointment resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        Appointment appointment = new Appointment();
        appointment.setStatus(Appointment.AppointmentStatus.PROPOSED);
        Appointment.AppointmentParticipantComponent patientParticipant = new Appointment.AppointmentParticipantComponent().setStatus(Appointment.ParticipationStatus.NEEDSACTION);
        patientParticipant.setActor(new Reference(request.getSubjectId()));
        appointment.addParticipant(patientParticipant);
        return appointment;
    }
}

