/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r4;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ImmunizationRecommendation;
import org.hl7.fhir.r4.model.Reference;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class ImmunizationRecommendationResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public ImmunizationRecommendationResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public ImmunizationRecommendation resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        ImmunizationRecommendation immunizationRecommendation = new ImmunizationRecommendation();
        immunizationRecommendation.setPatient(new Reference(request.getSubjectId()));
        immunizationRecommendation.setDate(new Date());
        if (this.activityDefinition.hasProductCodeableConcept()) {
            immunizationRecommendation.addRecommendation(new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent().addVaccineCode(this.activityDefinition.getProductCodeableConcept()).setForecastStatus(new CodeableConcept(new Coding("http://terminology.hl7.org/CodeSystem/immunization-recommendation-status", "due", "Due"))));
        } else if (!this.activityDefinition.hasDynamicValue()) {
            throw new FHIRException(String.format("Missing required ActivityDefinition.product property for %s", "ImmunizationRecommendation"));
        }
        return immunizationRecommendation;
    }
}

