/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.activitydefinition.apply.resolvers.r4;

import com.google.common.base.Preconditions;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.Type;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.BaseRequestResourceResolver;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;

public class SupplyRequestResolver
extends BaseRequestResourceResolver {
    private final ActivityDefinition activityDefinition;

    public SupplyRequestResolver(ActivityDefinition activityDefinition) {
        Preconditions.checkNotNull((Object)activityDefinition);
        this.activityDefinition = activityDefinition;
    }

    public SupplyRequest resolve(ICpgRequest request) {
        logger.debug("Resolving {} to {}", (Object)this.activityDefinition.getId(), (Object)this.activityDefinition.getKind());
        SupplyRequest supplyRequest = new SupplyRequest();
        supplyRequest.setStatus(SupplyRequest.SupplyRequestStatus.DRAFT);
        if (request.hasPractitionerId().booleanValue()) {
            supplyRequest.setRequester(new Reference(request.getPractitionerId()));
        }
        if (request.hasOrganizationId().booleanValue()) {
            supplyRequest.setRequester(new Reference(request.getOrganizationId()));
        }
        if (this.activityDefinition.hasQuantity()) {
            supplyRequest.setQuantity(this.activityDefinition.getQuantity());
        }
        if (this.activityDefinition.hasCode()) {
            supplyRequest.setItem((Type)this.activityDefinition.getCode());
        }
        return supplyRequest;
    }
}

