/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import java.util.List;
import org.hl7.fhir.dstu3.model.Element;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Expression;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicValueProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DynamicValueProcessor.class);

    public void processDynamicValues(ICpgRequest request, IBaseResource resource, IElement definitionElement) {
        IBaseResource context = definitionElement instanceof IBaseResource ? (IBaseResource)definitionElement : resource;
        this.processDynamicValues(request, context, resource, definitionElement, null);
    }

    public void processDynamicValues(ICpgRequest request, IBaseResource context, IBaseResource resource, IElement definitionElement, IElement requestAction) {
        List<IBaseBackboneElement> dynamicValues = request.getDynamicValues(definitionElement);
        for (IBaseBackboneElement dynamicValue : dynamicValues) {
            try {
                this.resolveDynamicValue(request, dynamicValue, context, resource, requestAction);
            }
            catch (Exception e) {
                String message = String.format("DynamicValue resolution for path %s encountered exception: %s", request.resolvePathString((IBase)dynamicValue, "path"), e.getMessage());
                logger.error(message);
                request.logException(message);
            }
        }
    }

    protected CqfExpression getDynamicValueExpression(ICpgRequest request, IBaseBackboneElement dynamicValue) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return new CqfExpression(request.resolvePathString((IBase)dynamicValue, "language"), request.resolvePathString((IBase)dynamicValue, "expression"), request.getDefaultLibraryUrl());
            }
            case R4: {
                return CqfExpression.of((Expression)request.resolvePath((IBase)dynamicValue, "expression", Expression.class), (String)request.getDefaultLibraryUrl());
            }
            case R5: {
                return CqfExpression.of((org.hl7.fhir.r5.model.Expression)request.resolvePath((IBase)dynamicValue, "expression", org.hl7.fhir.r5.model.Expression.class), (String)request.getDefaultLibraryUrl());
            }
        }
        return null;
    }

    protected void resolveDynamicValue(ICpgRequest request, IBaseBackboneElement dynamicValue, IBaseResource context, IBaseResource resource, IElement requestAction) {
        String path = request.resolvePathString((IBase)dynamicValue, "path");
        path = path.replace("%", "");
        CqfExpression cqfExpression = this.getDynamicValueExpression(request, dynamicValue);
        if (path != null && cqfExpression != null) {
            IBase value;
            IBase result = this.getDynamicValueExpressionResult(request, cqfExpression, context, resource);
            if (result == null || result.isEmpty()) {
                return;
            }
            IBase iBase = value = result.size() == 1 ? result.get(0) : result;
            if (this.requiresRequestAction(path, resource).booleanValue()) {
                if (requestAction == null) {
                    throw new IllegalArgumentException(String.format("Error resolving dynamicValue with path %s: expected requestAction not found", path));
                }
                if (this.isPriorityExtension(path).booleanValue()) {
                    if (request.getFhirVersion() != FhirVersionEnum.DSTU3) {
                        throw new IllegalArgumentException("Please use the priority path when setting indicator values when using FHIR R4 or higher for CDS Hooks evaluation");
                    }
                    ((Element)requestAction).addExtension().setValue((Type)value);
                } else {
                    request.getModelResolver().setValue((Object)requestAction, path.replace("action.", ""), (Object)value);
                }
            } else {
                request.getModelResolver().setValue((Object)resource, path, (Object)value);
            }
        }
    }

    protected List<IBase> getDynamicValueExpressionResult(ICpgRequest request, CqfExpression cqfExpression, IBaseResource context, IBaseResource resource) {
        return request.getLibraryEngine().resolveExpression(request.getSubjectId().getIdPart(), cqfExpression, request.getParameters(), request.getBundle(), (IBase)context, (IBase)resource);
    }

    private Boolean requiresRequestAction(String path, IBaseResource resource) {
        return this.isPriorityExtension(path) != false || this.isAction(path, resource) != false;
    }

    private Boolean isPriorityExtension(String path) {
        return path.startsWith("activity.extension") || path.startsWith("action.extension");
    }

    private Boolean isAction(String path, IBaseResource resource) {
        return path.startsWith("action.") || resource == null;
    }
}

