/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.model.api.IElement;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.opencds.cqf.fhir.cql.ExtensionResolver;
import org.opencds.cqf.fhir.cr.common.IOperationRequest;

public class ExtensionProcessor {
    public void processExtensions(IOperationRequest request, IBase resource, IElement definition, List<String> excludedExtList) {
        List<IBaseExtension<?, ?>> extensions = request.getExtensions((IBase)definition).stream().filter(e -> !excludedExtList.contains(e.getUrl())).collect(Collectors.toList());
        this.processExtensions(request, resource, extensions);
    }

    public void processExtensionsInList(IOperationRequest request, IBase resource, IElement definition, List<String> extList) {
        List<IBaseExtension<?, ?>> extensions = request.getExtensions((IBase)definition).stream().filter(e -> extList.contains(e.getUrl())).collect(Collectors.toList());
        this.processExtensions(request, resource, extensions);
    }

    private void processExtensions(IOperationRequest request, IBase resource, List<IBaseExtension<?, ?>> extensions) {
        if (extensions.isEmpty()) {
            return;
        }
        ExtensionResolver extensionResolver = new ExtensionResolver(request.getSubjectId(), request.getParameters(), request.getBundle(), request.getLibraryEngine());
        extensionResolver.resolveExtensions(resource, extensions, request.getDefaultLibraryUrl());
        request.getModelResolver().setValue((Object)resource, "extension", extensions);
    }
}

