/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.common;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.StringType;

public class ItemValueTransformer {
    private ItemValueTransformer() {
    }

    public static org.hl7.fhir.dstu3.model.Type transformValueToItem(org.hl7.fhir.dstu3.model.Type value) {
        if (value instanceof org.hl7.fhir.dstu3.model.CodeableConcept) {
            return (org.hl7.fhir.dstu3.model.Type)((org.hl7.fhir.dstu3.model.CodeableConcept)value).getCoding().get(0);
        }
        if (value instanceof org.hl7.fhir.dstu3.model.Enumeration) {
            return new org.hl7.fhir.dstu3.model.StringType(((org.hl7.fhir.dstu3.model.Enumeration)value).asStringValue());
        }
        return value;
    }

    public static Type transformValueToItem(Type value) {
        if (value instanceof CodeableConcept) {
            return (Type)((CodeableConcept)value).getCoding().get(0);
        }
        if (value instanceof Enumeration) {
            return new org.hl7.fhir.r4.model.StringType(((Enumeration)value).getCode());
        }
        return value;
    }

    public static DataType transformValueToItem(DataType value) {
        if (value instanceof org.hl7.fhir.r5.model.CodeableConcept) {
            return (DataType)((org.hl7.fhir.r5.model.CodeableConcept)value).getCoding().get(0);
        }
        if (value instanceof org.hl7.fhir.r5.model.Enumeration) {
            return new StringType(((org.hl7.fhir.r5.model.Enumeration)value).getCode());
        }
        return value;
    }

    public static IBase transformValueToResource(FhirVersionEnum fhirVersion, IBase value) {
        switch (fhirVersion) {
            case DSTU3: {
                return ItemValueTransformer.transformValueToResource((org.hl7.fhir.dstu3.model.Type)value);
            }
            case R4: {
                return ItemValueTransformer.transformValueToResource((Type)value);
            }
            case R5: {
                return ItemValueTransformer.transformValueToResource((DataType)value);
            }
        }
        return null;
    }

    public static org.hl7.fhir.dstu3.model.Type transformValueToResource(org.hl7.fhir.dstu3.model.Type value) {
        if (value instanceof Coding) {
            return new org.hl7.fhir.dstu3.model.CodeableConcept().addCoding((Coding)value);
        }
        return value;
    }

    public static Type transformValueToResource(Type value) {
        if (value instanceof org.hl7.fhir.r4.model.Coding) {
            return new CodeableConcept().addCoding((org.hl7.fhir.r4.model.Coding)value);
        }
        return value;
    }

    public static DataType transformValueToResource(DataType value) {
        if (value instanceof org.hl7.fhir.r5.model.Coding) {
            return new org.hl7.fhir.r5.model.CodeableConcept().addCoding((org.hl7.fhir.r5.model.Coding)value);
        }
        return value;
    }
}

