/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.inputparameters;

import ca.uhn.fhir.context.FhirContext;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.inputparameters.IInputParameterResolver;
import org.opencds.cqf.fhir.utility.repository.FederatedRepository;
import org.opencds.cqf.fhir.utility.repository.InMemoryFhirRepository;

public abstract class BaseInputParameterResolver
implements IInputParameterResolver {
    protected final IIdType subjectId;
    protected final IIdType encounterId;
    protected final IIdType practitionerId;
    protected Repository repository;

    public BaseInputParameterResolver(Repository repository, IIdType subjectId, IIdType encounterId, IIdType practitionerId, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle) {
        this.subjectId = subjectId;
        this.encounterId = encounterId;
        this.practitionerId = practitionerId;
        InMemoryFhirRepository bundleRepository = null;
        if (bundle != null) {
            bundleRepository = new InMemoryFhirRepository(repository.fhirContext(), bundle);
        }
        this.repository = this.resolveRepository(useServerData, repository, (Repository)bundleRepository);
    }

    protected final Repository resolveRepository(Boolean useServerData, Repository serverRepository, Repository bundleRepository) {
        if (bundleRepository == null) {
            return serverRepository;
        }
        return Boolean.TRUE.equals(useServerData) ? new FederatedRepository(serverRepository, new Repository[]{bundleRepository}) : bundleRepository;
    }

    protected FhirContext fhirContext() {
        return this.repository.fhirContext();
    }

    protected <R extends IBaseResource> R readRepository(Class<R> resourceType, IIdType id) {
        try {
            return (R)this.repository.read(resourceType, id, null);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected abstract IBaseParameters resolveParameters(IBaseParameters var1);
}

