/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.dstu3;

import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.dstu3.model.MeasureReport;
import org.opencds.cqf.fhir.cr.measure.common.BaseMeasureReportScorer;
import org.opencds.cqf.fhir.cr.measure.common.GroupDef;
import org.opencds.cqf.fhir.cr.measure.common.MeasurePopulationType;
import org.opencds.cqf.fhir.cr.measure.common.MeasureScoring;

public class Dstu3MeasureReportScorer
extends BaseMeasureReportScorer<MeasureReport> {
    @Override
    public void score(Map<GroupDef, MeasureScoring> measureScoring, MeasureReport measureReport) {
        if (measureReport.getGroup().isEmpty()) {
            return;
        }
        if (measureScoring == null || measureScoring.isEmpty()) {
            throw new IllegalArgumentException("Measure does not have a scoring methodology defined. Add a \"scoring\" property to the measure definition or the group definition.");
        }
        MeasureScoring scoring = measureScoring.values().iterator().next();
        for (MeasureReport.MeasureReportGroupComponent mrgc : measureReport.getGroup()) {
            this.scoreGroup(scoring, mrgc);
        }
    }

    protected void scoreGroup(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupComponent mrgc) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getPopulationCount(mrgc, MeasurePopulationType.NUMERATOR), this.getPopulationCount(mrgc, MeasurePopulationType.DENOMINATOR));
                if (score == null) break;
                mrgc.setMeasureScore(score.doubleValue());
                break;
            }
        }
        for (MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent : mrgc.getStratifier()) {
            this.scoreStratifier(measureScoring, stratifierComponent);
        }
    }

    protected void scoreStratum(MeasureScoring measureScoring, MeasureReport.StratifierGroupComponent stratum) {
        switch (measureScoring) {
            case PROPORTION: 
            case RATIO: {
                Double score = this.calcProportionScore(this.getPopulationCount(stratum, MeasurePopulationType.NUMERATOR), this.getPopulationCount(stratum, MeasurePopulationType.DENOMINATOR));
                if (score == null) break;
                stratum.setMeasureScore(score.doubleValue());
                break;
            }
        }
    }

    protected Integer getPopulationCount(MeasureReport.MeasureReportGroupComponent mrgc, MeasurePopulationType populationType) {
        Optional<MeasureReport.MeasureReportGroupPopulationComponent> pop = mrgc.getPopulation().stream().filter(x -> x.getCode().getCodingFirstRep().getCode().equals(populationType.toCode())).findFirst();
        if (pop.isPresent()) {
            return pop.get().getCount();
        }
        return null;
    }

    protected Integer getPopulationCount(MeasureReport.StratifierGroupComponent sgc, MeasurePopulationType populationType) {
        Optional<MeasureReport.StratifierGroupPopulationComponent> pop = sgc.getPopulation().stream().filter(x -> x.getCode().getCodingFirstRep().getCode().equals(populationType.toCode())).findFirst();
        if (pop.isPresent()) {
            return pop.get().getCount();
        }
        return null;
    }

    protected void scoreStratifier(MeasureScoring measureScoring, MeasureReport.MeasureReportGroupStratifierComponent stratifierComponent) {
        for (MeasureReport.StratifierGroupComponent sgc : stratifierComponent.getStratum()) {
            this.scoreStratum(measureScoring, sgc);
        }
    }
}

