/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.helper;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.TimeZone;
import org.opencds.cqf.cql.engine.runtime.DateTime;

public class DateHelper {
    public static DateTime resolveRequestDate(String date, boolean start) {
        boolean isOffsetDateString;
        if (date.contains("Z")) {
            OffsetDateTime offset = Instant.parse(date).atOffset(ZoneOffset.UTC);
            return new DateTime(offset);
        }
        boolean bl = isOffsetDateString = date.contains("T") && date.contains(".") && date.contains("-");
        if (isOffsetDateString) {
            OffsetDateTime offset = OffsetDateTime.parse(date, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            return new DateTime(offset);
        }
        if (date.contains("T")) {
            OffsetDateTime offset = LocalDateTime.parse(date, DateTimeFormatter.ISO_LOCAL_DATE_TIME).atZone(ZoneId.systemDefault()).toOffsetDateTime();
            return new DateTime(offset);
        }
        return DateHelper.resolveDate(start, date);
    }

    private static DateTime resolveDate(boolean start, String dateString) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        String[] dissect = dateString.split("-");
        ArrayList<Integer> dateVals = new ArrayList<Integer>();
        for (String dateElement : dissect) {
            dateVals.add(Integer.parseInt(dateElement));
        }
        if (dateVals.isEmpty()) {
            throw new IllegalArgumentException("Invalid date");
        }
        calendar.setTimeZone(TimeZone.getDefault());
        calendar.set(1, (Integer)dateVals.get(0));
        if (dateVals.size() > 1) {
            calendar.set(2, (Integer)dateVals.get(1) - 1);
        } else if (start) {
            calendar.set(2, 0);
        } else {
            calendar.set(2, 11);
        }
        if (dateVals.size() > 2) {
            calendar.set(5, (Integer)dateVals.get(2));
        } else if (start) {
            calendar.set(5, 1);
        } else {
            calendar.add(2, 1);
            calendar.set(5, 1);
            calendar.add(5, -1);
        }
        if (start) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        OffsetDateTime offset = calendar.toInstant().atZone(ZoneId.systemDefault()).toOffsetDateTime();
        return new DateTime(offset);
    }
}

