/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.measure.r4;

import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Resource;
import org.opencds.cqf.fhir.api.Repository;

public class R4SubmitDataService {
    private final Repository repository;

    public R4SubmitDataService(Repository repository) {
        this.repository = repository;
    }

    public Bundle submitData(IdType id, MeasureReport report, List<IBaseResource> resources) {
        Bundle transactionBundle = new Bundle().setType(Bundle.BundleType.TRANSACTION).addEntry(this.createEntry((IBaseResource)report));
        if (resources != null) {
            for (IBaseResource res : resources) {
                if (res instanceof Bundle) {
                    Bundle nestedBundle = (Bundle)res;
                    for (Bundle.BundleEntryComponent entry : nestedBundle.getEntry()) {
                        transactionBundle.addEntry(this.createEntry((IBaseResource)entry.getResource()));
                    }
                    continue;
                }
                transactionBundle.addEntry(this.createEntry(res));
            }
        }
        return (Bundle)this.repository.transaction((IBaseBundle)transactionBundle);
    }

    private Bundle.BundleEntryComponent createEntry(IBaseResource resource) {
        return new Bundle.BundleEntryComponent().setResource((Resource)resource).setRequest(this.createRequest(resource));
    }

    private Bundle.BundleEntryRequestComponent createRequest(IBaseResource resource) {
        Bundle.BundleEntryRequestComponent request = new Bundle.BundleEntryRequestComponent();
        if (resource.getIdElement().hasValue()) {
            request.setMethod(Bundle.HTTPVerb.PUT).setUrl(resource.getIdElement().getValue());
        } else {
            request.setMethod(Bundle.HTTPVerb.POST).setUrl(resource.fhirType());
        }
        return request;
    }
}

