/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cql.EvaluationSettings;
import org.opencds.cqf.fhir.cql.LibraryEngine;
import org.opencds.cqf.fhir.cql.engine.model.FhirModelResolverCache;
import org.opencds.cqf.fhir.cr.activitydefinition.apply.IRequestResolverFactory;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.cr.common.ResourceResolver;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.IApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.packages.PackageProcessor;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.monad.Either3;
import org.opencds.cqf.fhir.utility.repository.Repositories;

public class PlanDefinitionProcessor {
    protected final ModelResolver modelResolver;
    protected final FhirVersionEnum fhirVersion;
    protected final IApplyProcessor applyProcessor;
    protected final IPackageProcessor packageProcessor;
    protected final org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor;
    protected final IRequestResolverFactory requestResolverFactory;
    protected Repository repository;
    protected EvaluationSettings evaluationSettings;

    public PlanDefinitionProcessor(Repository repository) {
        this(repository, EvaluationSettings.getDefault());
    }

    public PlanDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings) {
        this(repository, evaluationSettings, null, null, null, null);
    }

    public PlanDefinitionProcessor(Repository repository, EvaluationSettings evaluationSettings, IApplyProcessor applyProcessor, IPackageProcessor packageProcessor, org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor, IRequestResolverFactory requestResolverFactory) {
        this.repository = Objects.requireNonNull(repository, "repository can not be null");
        this.evaluationSettings = Objects.requireNonNull(evaluationSettings, "evaluationSettings can not be null");
        this.fhirVersion = this.repository.fhirContext().getVersion().getVersion();
        this.modelResolver = FhirModelResolverCache.resolverForVersion((FhirVersionEnum)this.fhirVersion);
        this.packageProcessor = packageProcessor != null ? packageProcessor : new PackageProcessor(this.repository);
        this.requestResolverFactory = requestResolverFactory != null ? requestResolverFactory : IRequestResolverFactory.getDefault(this.fhirVersion);
        this.activityProcessor = activityProcessor != null ? activityProcessor : new org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyProcessor(this.repository, this.requestResolverFactory);
        this.applyProcessor = applyProcessor != null ? applyProcessor : new ApplyProcessor(this.repository, this.modelResolver, this.activityProcessor);
    }

    public EvaluationSettings evaluationSettings() {
        return this.evaluationSettings;
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> R resolvePlanDefinition(Either3<C, IIdType, R> planDefinition) {
        return new ResourceResolver("PlanDefinition", this.repository).resolve(planDefinition);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packagePlanDefinition(Either3<C, IIdType, R> planDefinition) {
        return this.packageProcessor.packageResource((IBaseResource)this.resolvePlanDefinition(planDefinition));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle packagePlanDefinition(Either3<C, IIdType, R> planDefinition, boolean isPut) {
        return this.packageProcessor.packageResource((IBaseResource)this.resolvePlanDefinition(planDefinition), isPut ? "PUT" : "POST");
    }

    protected <C extends IPrimitiveType<String>, R extends IBaseResource> ApplyRequest buildApplyRequest(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, LibraryEngine libraryEngine) {
        return new ApplyRequest((IBaseResource)this.resolvePlanDefinition(planDefinition), Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)subject, (String)"Patient")), encounter == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)encounter, (String)"Encounter")), practitioner == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)practitioner, (String)"Practitioner")), organization == null ? null : Ids.newId((FhirVersionEnum)this.fhirVersion, (String)Ids.ensureIdType((String)organization, (String)"Organization")), userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, libraryEngine, this.modelResolver, null);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext) {
        return this.apply(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, null, true, null, null, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.apply(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, Repository dataRepository, Repository contentRepository, Repository terminologyRepository) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.apply(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseResource apply(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, LibraryEngine libraryEngine) {
        if (this.fhirVersion == FhirVersionEnum.R5) {
            return this.applyR5(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, libraryEngine);
        }
        return this.apply(this.buildApplyRequest(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, libraryEngine));
    }

    public IBaseResource apply(ApplyRequest request) {
        return this.applyProcessor.apply(request);
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle applyR5(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, IBaseResource dataEndpoint, IBaseResource contentEndpoint, IBaseResource terminologyEndpoint) {
        return this.applyR5(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)dataEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)contentEndpoint), Repositories.createRestRepository((FhirContext)this.repository.fhirContext(), (IBaseResource)terminologyEndpoint));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle applyR5(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, Repository dataRepository, Repository contentRepository, Repository terminologyRepository) {
        this.repository = Repositories.proxy((Repository)this.repository, (Boolean)useServerData, (Repository)dataRepository, (Repository)contentRepository, (Repository)terminologyRepository);
        return this.applyR5(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, new LibraryEngine(this.repository, this.evaluationSettings));
    }

    public <C extends IPrimitiveType<String>, R extends IBaseResource> IBaseBundle applyR5(Either3<C, IIdType, R> planDefinition, String subject, String encounter, String practitioner, String organization, IBaseDatatype userType, IBaseDatatype userLanguage, IBaseDatatype userTaskContext, IBaseDatatype setting, IBaseDatatype settingContext, IBaseParameters parameters, Boolean useServerData, IBaseBundle bundle, IBaseParameters prefetchData, LibraryEngine libraryEngine) {
        return this.applyR5(this.buildApplyRequest(planDefinition, subject, encounter, practitioner, organization, userType, userLanguage, userTaskContext, setting, settingContext, parameters, useServerData, bundle, prefetchData, libraryEngine));
    }

    public IBaseBundle applyR5(ApplyRequest request) {
        return this.applyProcessor.applyR5(request);
    }
}

