/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ExtensionProcessor;
import org.opencds.cqf.fhir.cr.common.ICpgRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.cr.plandefinition.apply.IApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ProcessAction;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ProcessGoal;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ProcessRequest;
import org.opencds.cqf.fhir.cr.questionnaire.generate.GenerateProcessor;
import org.opencds.cqf.fhir.cr.questionnaireresponse.QuestionnaireResponseProcessor;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.dstu3.ContainedHelper;
import org.opencds.cqf.fhir.utility.monad.Eithers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyProcessor
implements IApplyProcessor {
    private static final Logger logger = LoggerFactory.getLogger(ApplyProcessor.class);
    protected static final List<String> EXCLUDED_EXTENSION_LIST = Arrays.asList("http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeCapability", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-knowledgeRepresentationLevel", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-softwaresystem", "http://hl7.org/fhir/uv/cpg/StructureDefinition/cpg-questionnaire-generate", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-logicDefinition", "http://hl7.org/fhir/us/cqfmeasures/StructureDefinition/cqfm-effectiveDataRequirements");
    protected final Repository repository;
    protected final ModelResolver modelResolver;
    protected final ExtensionProcessor extensionProcessor;
    protected final GenerateProcessor generateProcessor;
    protected final QuestionnaireResponseProcessor extractProcessor;
    protected final ProcessRequest processRequest;
    protected final ProcessGoal processGoal;
    protected final ProcessAction processAction;
    protected final org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor;

    public ApplyProcessor(Repository repository, ModelResolver modelResolver, org.opencds.cqf.fhir.cr.activitydefinition.apply.IApplyProcessor activityProcessor) {
        this.repository = repository;
        this.modelResolver = modelResolver;
        this.activityProcessor = activityProcessor;
        this.extensionProcessor = new ExtensionProcessor();
        this.generateProcessor = new GenerateProcessor(this.repository);
        this.extractProcessor = new QuestionnaireResponseProcessor(this.repository);
        this.processRequest = new ProcessRequest();
        this.processGoal = new ProcessGoal();
        this.processAction = new ProcessAction(this.repository, this, this.generateProcessor);
    }

    @Override
    public IBaseResource apply(ApplyRequest request) {
        request.setContainResources(true);
        this.initApply(request);
        IBaseResource requestOrchestration = this.applyPlanDefinition(request);
        request.resolveOperationOutcome(requestOrchestration);
        IBaseResource carePlan = this.processRequest.generateCarePlan(request, requestOrchestration);
        return this.liftContainedResourcesToParent(request, carePlan);
    }

    @Override
    public IBaseBundle applyR5(ApplyRequest request) {
        this.initApply(request);
        IBaseResource requestOrchestration = this.applyPlanDefinition(request);
        request.resolveOperationOutcome(requestOrchestration);
        IBaseBundle resultBundle = BundleHelper.newBundle((FhirVersionEnum)request.getFhirVersion(), (String)requestOrchestration.getIdElement().getIdPart(), null);
        BundleHelper.addEntry((IBaseBundle)resultBundle, (IBaseBackboneElement)BundleHelper.newEntryWithResource((FhirVersionEnum)request.getFhirVersion(), (IBaseResource)requestOrchestration));
        for (IBaseResource resource : request.getRequestResources()) {
            BundleHelper.addEntry((IBaseBundle)resultBundle, (IBaseBackboneElement)BundleHelper.newEntryWithResource((FhirVersionEnum)request.getFhirVersion(), (IBaseResource)resource));
        }
        for (IBaseResource resource : request.getExtractedResources()) {
            BundleHelper.addEntry((IBaseBundle)resultBundle, (IBaseBackboneElement)BundleHelper.newEntryWithResource((FhirVersionEnum)request.getFhirVersion(), (IBaseResource)resource));
        }
        if (!request.getItems((IBase)request.getQuestionnaire()).isEmpty()) {
            BundleHelper.addEntry((IBaseBundle)resultBundle, (IBaseBackboneElement)BundleHelper.newEntryWithResource((FhirVersionEnum)request.getFhirVersion(), (IBaseResource)request.getQuestionnaire()));
        }
        return resultBundle;
    }

    protected void initApply(ApplyRequest request) {
        request.setQuestionnaire(this.generateProcessor.generate(request.getPlanDefinition().getIdElement().getIdPart()));
        this.extractQuestionnaireResponse(request);
    }

    protected void extractQuestionnaireResponse(ApplyRequest request) {
        if (request.getBundle() == null) {
            return;
        }
        List questionnaireResponses = BundleHelper.getEntryResources((IBaseBundle)request.getBundle()).stream().filter(r -> r.fhirType().equals("QuestionnaireResponse")).collect(Collectors.toList());
        if (questionnaireResponses != null && !questionnaireResponses.isEmpty()) {
            for (IBaseResource questionnaireResponse : questionnaireResponses) {
                try {
                    IBaseBundle extractBundle = this.extractProcessor.extract(Eithers.forRight((Object)questionnaireResponse), request.getParameters(), request.getBundle(), request.getLibraryEngine());
                    request.getExtractedResources().add(questionnaireResponse);
                    for (IBaseBackboneElement entry : BundleHelper.getEntry((IBaseBundle)extractBundle)) {
                        BundleHelper.addEntry((IBaseBundle)request.getBundle(), (IBaseBackboneElement)entry);
                    }
                }
                catch (Exception e) {
                    request.logException(String.format("Error encountered extracting %s: %s", questionnaireResponse.getIdElement().getIdPart(), e.getMessage()));
                }
            }
        }
    }

    public IBaseResource applyPlanDefinition(ApplyRequest request) {
        logger.info("Performing $apply operation on PlanDefinition/{}", (Object)request.getPlanDefinition().getIdElement().getIdPart());
        IBaseResource requestOrchestration = this.processRequest.generateRequestOrchestration(request);
        this.extensionProcessor.processExtensions(request, (IBase)requestOrchestration, (IElement)request.getPlanDefinition(), EXCLUDED_EXTENSION_LIST);
        this.processGoals(request, requestOrchestration);
        HashMap<String, IBaseBackboneElement> metConditions = new HashMap<String, IBaseBackboneElement>();
        for (IBaseBackboneElement action : request.resolvePathList((IBase)request.getPlanDefinition(), "action", IBaseBackboneElement.class)) {
            request.getModelResolver().setValue((Object)requestOrchestration, "action", Collections.singletonList(this.processAction.processAction(request, requestOrchestration, metConditions, action)));
        }
        return Boolean.TRUE.equals(request.getContainResources()) ? this.liftContainedResourcesToParent(request, requestOrchestration) : requestOrchestration;
    }

    public IBaseResource applyActivityDefinition(org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest request) {
        return this.liftContainedResourcesToParent(request, this.activityProcessor.apply(request));
    }

    protected void processGoals(ApplyRequest request, IBaseResource requestOrchestration) {
        List<IBaseBackboneElement> goals = request.resolvePathList((IBase)request.getPlanDefinition(), "goal", IBaseBackboneElement.class);
        for (int i = 0; i < goals.size(); ++i) {
            IBaseResource goal = this.processGoal.convertGoal(request, goals.get(i));
            if (Boolean.TRUE.equals(request.getContainResources())) {
                request.getModelResolver().setValue((Object)requestOrchestration, "contained", Collections.singletonList(goal));
            } else {
                goal.setId(Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)"Goal", (String)String.valueOf(i + 1)));
                request.getModelResolver().setValue((Object)requestOrchestration, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(request.getFhirVersion(), ExtensionBuilders.pertainToGoalExtension(goal.getIdElement().getValue()), request.getContainResources())));
            }
            request.getRequestResources().add(goal);
        }
    }

    protected IBaseResource liftContainedResourcesToParent(ICpgRequest request, IBaseResource resource) {
        switch (request.getFhirVersion()) {
            case DSTU3: {
                return ContainedHelper.liftContainedResourcesToParent((org.hl7.fhir.dstu3.model.DomainResource)((org.hl7.fhir.dstu3.model.DomainResource)resource));
            }
            case R4: {
                return org.opencds.cqf.fhir.utility.r4.ContainedHelper.liftContainedResourcesToParent((DomainResource)((DomainResource)resource));
            }
            case R5: {
                return org.opencds.cqf.fhir.utility.r5.ContainedHelper.liftContainedResourcesToParent((org.hl7.fhir.r5.model.DomainResource)((org.hl7.fhir.r5.model.DomainResource)resource));
            }
        }
        return resource;
    }
}

