/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.plandefinition.apply;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Enumerations;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ActionResolver;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyProcessor;
import org.opencds.cqf.fhir.cr.plandefinition.apply.ApplyRequest;
import org.opencds.cqf.fhir.utility.Ids;
import org.opencds.cqf.fhir.utility.SearchHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDefinition {
    private static final Logger logger = LoggerFactory.getLogger(ProcessDefinition.class);
    final Repository repository;
    final ApplyProcessor applyProcessor;
    final ActionResolver actionResolver;

    public ProcessDefinition(Repository repository, ApplyProcessor applyProcessor) {
        Objects.requireNonNull(repository);
        Objects.requireNonNull(applyProcessor);
        this.repository = repository;
        this.applyProcessor = applyProcessor;
        this.actionResolver = new ActionResolver();
    }

    public IBaseResource resolveDefinition(ApplyRequest request, IBaseResource requestOrchestration, IBaseBackboneElement action, IBaseBackboneElement requestAction) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(requestOrchestration);
        Objects.requireNonNull(action);
        Objects.requireNonNull(requestAction);
        IBaseResource resource = null;
        IPrimitiveType<String> definition = this.getDefinition(request, action);
        if (this.isDefinitionCanonical(request, (IBase)definition).booleanValue()) {
            resource = this.resolveDefinition(request, definition);
            if (resource != null) {
                String actionId = request.resolvePathString((IBase)action, "id");
                if (actionId != null) {
                    resource.setId(String.format("%s-%s", actionId, resource.getIdElement().getIdPart()));
                }
                this.actionResolver.resolveAction(request, requestOrchestration, resource, action);
                request.getModelResolver().setValue((Object)requestAction, "resource", (Object)ExtensionBuilders.buildReference(request.getFhirVersion(), resource.getIdElement().getValue()));
                if (Boolean.TRUE.equals(request.getContainResources())) {
                    request.getModelResolver().setValue((Object)requestOrchestration, "contained", Collections.singletonList(resource));
                } else {
                    request.getRequestResources().add(resource);
                }
            }
        } else if (this.isDefinitionUri(request, (IBase)definition).booleanValue()) {
            request.getModelResolver().setValue((Object)requestAction, "resource", (Object)ExtensionBuilders.buildReference(request.getFhirVersion(), (String)definition.getValue()));
        }
        return resource;
    }

    protected IPrimitiveType<String> getDefinition(ApplyRequest request, IBaseBackboneElement action) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(action);
        return request.getFhirVersion().isOlderThan(FhirVersionEnum.R4) ? request.resolvePath(request.resolvePath((IBase)action, "definition"), "reference", IPrimitiveType.class) : request.resolvePath((IBase)action, "definition", IPrimitiveType.class);
    }

    protected IBaseResource resolveDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        logger.debug("Resolving definition {}", definition.getValue());
        String resourceName = this.resolveResourceName(request, definition);
        switch (Enumerations.FHIRTypes.fromCode((String)Objects.requireNonNull(resourceName))) {
            case PLANDEFINITION: {
                return this.applyNestedPlanDefinition(request, definition);
            }
            case ACTIVITYDEFINITION: {
                return this.applyActivityDefinition(request, definition);
            }
            case QUESTIONNAIRE: {
                return this.applyQuestionnaireDefinition(request, definition);
            }
        }
        throw new FHIRException(String.format("Unknown action definition: %s", definition.getValue()));
    }

    protected Boolean isDefinitionCanonical(ApplyRequest request, IBase definition) {
        Objects.requireNonNull(request);
        switch (request.getFhirVersion()) {
            case R4: {
                return definition instanceof CanonicalType;
            }
            case R5: {
                return definition instanceof org.hl7.fhir.r5.model.CanonicalType;
            }
        }
        return definition != null;
    }

    protected Boolean isDefinitionUri(ApplyRequest request, IBase definition) {
        Objects.requireNonNull(request);
        switch (request.getFhirVersion()) {
            case R4: {
                return definition instanceof UriType;
            }
            case R5: {
                return definition instanceof org.hl7.fhir.r5.model.UriType;
            }
        }
        return Boolean.FALSE;
    }

    protected IBaseResource applyQuestionnaireDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        IBaseResource result = null;
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            result = referenceToContained ? this.resolveContained(request, (String)definition.getValue()) : this.resolveRepository(definition);
        }
        catch (Exception e) {
            String message = String.format("ERROR: Questionnaire %s could not be applied and threw exception %s", definition.getValue(), e.toString());
            logger.error(message);
            request.logException(message);
        }
        return result;
    }

    protected IBaseResource applyActivityDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        IBaseResource result = null;
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            IBaseResource activityDefinition = referenceToContained ? this.resolveContained(request, (String)definition.getValue()) : this.resolveRepository(definition);
            org.opencds.cqf.fhir.cr.activitydefinition.apply.ApplyRequest activityRequest = request.toActivityRequest(activityDefinition);
            result = this.applyProcessor.applyActivityDefinition(activityRequest);
            result.setId(referenceToContained ? Ids.newId((FhirVersionEnum)request.getFhirVersion(), (String)result.fhirType(), (String)activityDefinition.getIdElement().getIdPart().replaceFirst("#", "")) : activityDefinition.getIdElement().withResourceType(result.fhirType()));
        }
        catch (Exception e) {
            String message = String.format("ERROR: ActivityDefinition %s could not be applied and threw exception %s", definition.getValue(), e.toString());
            logger.error(message);
            request.logException(message);
        }
        return result;
    }

    protected IBaseResource applyNestedPlanDefinition(ApplyRequest request, IPrimitiveType<String> definition) {
        Objects.requireNonNull(definition);
        try {
            boolean referenceToContained = ((String)definition.getValue()).startsWith("#");
            IBaseResource nextPlanDefinition = referenceToContained ? this.resolveContained(request, (String)definition.getValue()) : this.resolveRepository(definition);
            ApplyRequest nestedRequest = request.copy(nextPlanDefinition);
            IBaseResource result = this.applyProcessor.applyPlanDefinition(nestedRequest);
            request.getRequestResources().addAll(nestedRequest.getRequestResources());
            request.getExtractedResources().addAll(nestedRequest.getExtractedResources());
            request.setQuestionnaire(nestedRequest.getQuestionnaire());
            return result;
        }
        catch (Exception e) {
            String message = String.format("ERROR: PlanDefinition %s could not be applied and threw exception %s", definition.getValue(), e.toString());
            logger.error(message);
            request.logException(message);
            return null;
        }
    }

    protected IBaseResource resolveRepository(IPrimitiveType<String> definition) {
        return SearchHelper.searchRepositoryByCanonical((Repository)this.repository, definition);
    }

    protected String resolveResourceName(ApplyRequest request, IPrimitiveType<String> canonical) {
        Objects.requireNonNull(canonical);
        if (canonical.hasValue()) {
            String id = (String)canonical.getValue();
            if (id.contains("/")) {
                return (id = id.replace(id.substring(id.lastIndexOf("/")), "")).contains("/") ? id.substring(id.lastIndexOf("/") + 1) : id;
            }
            if (id.startsWith("#")) {
                return this.resolveContained(request, id).fhirType();
            }
            return null;
        }
        throw new FHIRException("CanonicalType must have a value for resource name extraction");
    }

    protected IBaseResource resolveContained(ApplyRequest request, String id) {
        Objects.requireNonNull(id);
        List<IBaseResource> contained = request.resolvePathList((IBase)request.getPlanDefinition(), "contained", IBaseResource.class);
        Optional<IBaseResource> first = contained.stream().filter(r -> r.getIdElement().getIdPart().equals(id)).findFirst();
        return first.orElse(null);
    }
}

