/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.packages;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.List;
import org.hl7.fhir.dstu3.model.Bundle;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.Extension;
import org.opencds.cqf.fhir.api.Repository;
import org.opencds.cqf.fhir.cr.common.IPackageProcessor;
import org.opencds.cqf.fhir.utility.BundleHelper;
import org.opencds.cqf.fhir.utility.r5.PackageHelper;
import org.opencds.cqf.fhir.utility.r5.SearchHelper;

public class PackageProcessor
implements IPackageProcessor {
    protected final Repository repository;
    protected final FhirVersionEnum fhirVersion;

    public PackageProcessor(Repository repository) {
        this.repository = repository;
        this.fhirVersion = repository.fhirContext().getVersion().getVersion();
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource) {
        return this.packageResource(resource, "POST");
    }

    @Override
    public IBaseBundle packageResource(IBaseResource resource, String method) {
        return this.packageQuestionnaire(resource, method.equals("PUT"));
    }

    protected IBaseBundle packageQuestionnaire(IBaseResource questionnaire, boolean isPut) {
        switch (this.fhirVersion) {
            case DSTU3: {
                return this.packageDstu3(questionnaire, isPut);
            }
            case R4: {
                return this.packageR4(questionnaire, isPut);
            }
            case R5: {
                return this.packageR5(questionnaire, isPut);
            }
        }
        return null;
    }

    protected IBaseBundle packageDstu3(IBaseResource questionnaire, Boolean isPut) {
        UriType libraryCanonical;
        org.hl7.fhir.dstu3.model.Library library;
        org.hl7.fhir.dstu3.model.Bundle bundle = new org.hl7.fhir.dstu3.model.Bundle();
        bundle.setType(Bundle.BundleType.TRANSACTION);
        BundleHelper.addEntry((IBaseBundle)bundle, (IBaseBackboneElement)org.opencds.cqf.fhir.utility.dstu3.PackageHelper.createEntry((IBaseResource)((Resource)questionnaire), (boolean)isPut));
        org.hl7.fhir.dstu3.model.Extension libraryExtension = ((org.hl7.fhir.dstu3.model.Questionnaire)questionnaire).getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library");
        if (libraryExtension != null && (library = (org.hl7.fhir.dstu3.model.Library)org.opencds.cqf.fhir.utility.dstu3.SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)(libraryCanonical = (UriType)libraryExtension.getValue()))) != null) {
            BundleHelper.addEntry((IBaseBundle)bundle, (IBaseBackboneElement)org.opencds.cqf.fhir.utility.dstu3.PackageHelper.createEntry((IBaseResource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                org.opencds.cqf.fhir.utility.dstu3.PackageHelper.addRelatedArtifacts((IBaseBundle)bundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        return bundle;
    }

    protected IBaseBundle packageR4(IBaseResource questionnaire, Boolean isPut) {
        CanonicalType libraryCanonical;
        Library library;
        Bundle bundle = new Bundle();
        bundle.setType(Bundle.BundleType.TRANSACTION);
        bundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)((org.hl7.fhir.r4.model.Resource)questionnaire), (boolean)isPut));
        org.hl7.fhir.r4.model.Extension libraryExtension = ((Questionnaire)questionnaire).getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library");
        if (libraryExtension != null && (library = (Library)org.opencds.cqf.fhir.utility.r4.SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)(libraryCanonical = (CanonicalType)libraryExtension.getValue()))) != null) {
            bundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                org.opencds.cqf.fhir.utility.r4.PackageHelper.addRelatedArtifacts((IBaseBundle)bundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        return bundle;
    }

    protected IBaseBundle packageR5(IBaseResource questionnaire, Boolean isPut) {
        org.hl7.fhir.r5.model.CanonicalType libraryCanonical;
        org.hl7.fhir.r5.model.Library library;
        org.hl7.fhir.r5.model.Bundle bundle = new org.hl7.fhir.r5.model.Bundle();
        bundle.setType(Bundle.BundleType.TRANSACTION);
        bundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)((org.hl7.fhir.r5.model.Resource)questionnaire), (boolean)isPut));
        Extension libraryExtension = ((org.hl7.fhir.r5.model.Questionnaire)questionnaire).getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/cqf-library");
        if (libraryExtension != null && (library = (org.hl7.fhir.r5.model.Library)SearchHelper.searchRepositoryByCanonical((Repository)this.repository, (IPrimitiveType)(libraryCanonical = (org.hl7.fhir.r5.model.CanonicalType)libraryExtension.getValue()))) != null) {
            bundle.addEntry((Bundle.BundleEntryComponent)org.opencds.cqf.fhir.utility.PackageHelper.createEntry((IBaseResource)library, (boolean)isPut));
            if (library.hasRelatedArtifact()) {
                PackageHelper.addRelatedArtifacts((IBaseBundle)bundle, (List)library.getRelatedArtifact(), (Repository)this.repository, (boolean)isPut);
            }
        }
        return bundle;
    }
}

