/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.fhir.cr.questionnaire.populate;

import ca.uhn.fhir.context.FhirVersionEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.opencds.cqf.fhir.cql.CqfExpression;
import org.opencds.cqf.fhir.cr.common.ExpressionProcessor;
import org.opencds.cqf.fhir.cr.common.ExtensionBuilders;
import org.opencds.cqf.fhir.cr.common.ItemValueTransformer;
import org.opencds.cqf.fhir.cr.common.ResolveExpressionException;
import org.opencds.cqf.fhir.cr.questionnaire.populate.PopulateRequest;

public class ProcessItemWithContext {
    private final ExpressionProcessor expressionProcessor;

    public ProcessItemWithContext() {
        this(new ExpressionProcessor());
    }

    private ProcessItemWithContext(ExpressionProcessor expressionProcessor) {
        this.expressionProcessor = expressionProcessor;
    }

    List<IBaseBackboneElement> processItem(PopulateRequest request, IBaseBackboneElement item) throws ResolveExpressionException {
        String itemLinkId = request.getItemLinkId(item);
        CqfExpression contextExpression = this.expressionProcessor.getCqfExpression(request, item.getExtension(), "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaire-itemPopulationContext");
        List<IBase> populationContext = this.expressionProcessor.getExpressionResultForItem(request, contextExpression, itemLinkId);
        return populationContext.stream().map(context -> this.processPopulationContext(request, item, (IBase)context)).collect(Collectors.toList());
    }

    IBaseBackboneElement processPopulationContext(PopulateRequest request, IBaseBackboneElement groupItem, IBase context) {
        IBaseBackboneElement contextItem = this.copyItemWithNoSubItems(request, groupItem);
        request.getItems((IBase)groupItem).forEach(item -> {
            IBaseBackboneElement processedSubItem = this.createNewQuestionnaireItemComponent(request, (IBaseBackboneElement)item, context);
            request.getModelResolver().setValue((Object)contextItem, "item", Collections.singletonList(processedSubItem));
        });
        return contextItem;
    }

    IBaseBackboneElement createNewQuestionnaireItemComponent(PopulateRequest request, IBaseBackboneElement item, IBase context) {
        IBaseBackboneElement populatedItem = (IBaseBackboneElement)SerializationUtils.clone((Serializable)item);
        String path = ((String)((IPrimitiveType)request.getModelResolver().resolvePath((Object)item, "definition")).getValue()).split("#")[1].split("\\.")[1].replace("[x]", "");
        Object initialValue = request.getModelResolver().resolvePath((Object)context, path);
        if (initialValue != null) {
            request.getModelResolver().setValue((Object)populatedItem, "extension", Collections.singletonList(ExtensionBuilders.buildReferenceExt(request.getFhirVersion(), ExtensionBuilders.QUESTIONNAIRE_RESPONSE_AUTHOR_EXTENSION, false)));
        }
        if (initialValue instanceof IBase) {
            request.getModelResolver().setValue((Object)populatedItem, "initial", Collections.singletonList(this.createInitial(request.getFhirVersion(), (IBase)initialValue)));
        } else if (initialValue instanceof List) {
            ArrayList<IBaseBackboneElement> initials = new ArrayList<IBaseBackboneElement>();
            for (IBase value : (List)initialValue) {
                initials.add(this.createInitial(request.getFhirVersion(), value));
            }
            request.getModelResolver().setValue((Object)populatedItem, "initial", initials);
        }
        return populatedItem;
    }

    IBaseBackboneElement copyItemWithNoSubItems(PopulateRequest request, IBaseBackboneElement item) {
        IBaseBackboneElement clone = (IBaseBackboneElement)SerializationUtils.clone((Serializable)item);
        request.getModelResolver().setValue((Object)clone, "item", null);
        return clone;
    }

    IBaseBackboneElement createInitial(FhirVersionEnum fhirVersion, IBase value) {
        switch (fhirVersion) {
            case DSTU3: {
                return new Questionnaire.QuestionnaireItemOptionComponent().setValue(ItemValueTransformer.transformValueToItem((org.hl7.fhir.dstu3.model.Type)value));
            }
            case R4: {
                return new Questionnaire.QuestionnaireItemInitialComponent().setValue(ItemValueTransformer.transformValueToItem((Type)value));
            }
            case R5: {
                return new Questionnaire.QuestionnaireItemInitialComponent().setValue(ItemValueTransformer.transformValueToItem((DataType)value));
            }
        }
        return null;
    }
}

